/** @file document/MoveTrackAttachmentDelta.cpp
 *  @brief Implement the Document::TrackAttachmentPositionFinder and Document::MoveNodeDelta classes.
 *  @author James Legg
 */
/* Copyright © 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "MoveTrackAttachmentDelta.h"
#include <vector>
#include <boost/shared_ptr.hpp>
#include "../Track.h"

namespace Document
{

TrackAttachmentPositionFinder::TrackAttachmentPositionFinder(
                           std::size_t edge_name, std::size_t attachment_name)
    :   m_edge_name(edge_name)
    ,   m_attachment_name(attachment_name)
{
}

void TrackAttachmentPositionFinder::read(const Track::Track & track,
                                         btVector3 & position)
{
    const Track::PathEdge & edge(track.get_path().get_edge(m_edge_name));
    const Track::TrackAttachment & attachment = edge.get_attachment(m_attachment_name);
    position = btVector3(attachment.get_t_position(), 
                         attachment.get_lateral_position(),
                         attachment.get_vertical_position());
}

void TrackAttachmentPositionFinder::write(Track::Track & track,
                                          const btVector3 & new_position)
{
    Track::PathEdge & edge (track.get_path().get_edge(m_edge_name));
    Track::TrackAttachment attachment = edge.get_attachment(m_attachment_name);
    attachment.set_t_position(new_position.x());
    attachment.set_lateral_position(new_position.y());
    attachment.set_vertical_position(new_position.z());
    edge.set_attachment(m_attachment_name, attachment);
}

} // namespace Document
