/** @file document/MoveNodeDelta.h
 *  @brief Declare the Document::MoveNodeDelta class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef MOVE_NODE_DELTA_H_
#define MOVE_NODE_DELTA_H_

#include "ChangePropertyDelta.h"

#include <LinearMath/btVector3.h>
#include <cstddef>

namespace Document
{

/** Find or set the position of a vertex.
 */
class NodePositionFinder : public PropertyDeltaIdentifier<btVector3>
{
public:
    /** Create, associating with a vertex.
     * @param node_id The name of the vertex to associate with.
     */
    NodePositionFinder(std::size_t node_id);
    /** Get the location of the associated vertex.
     * @param track The Track the associated vertex is in.
     * @param position Variable to set to the current position.
     */
    virtual void read(const Track::Track & track, btVector3 & position);
    /** Move the associated vertex.
     * @param track The Track containing the associated vertex.
     * @param new_position The location to move the associated vertex to.
     */
    virtual void write(Track::Track & track, const btVector3 & new_position);
protected:
    /// The name of the vertex.
    std::size_t node_id;
};

/** Command for moving control points along the path.
*/
typedef ChangePropertyDelta<NodePositionFinder, btVector3> MoveNodeDelta;

}

#endif
