/** @file document/MoveNodeDelta.cpp
 *  @brief Implement the Document::MoveNodeDelta class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "MoveNodeDelta.h"
#include "../Track.h"

namespace Document
{

NodePositionFinder::NodePositionFinder(std::size_t node_id)
    :   node_id(node_id)
{
}

void NodePositionFinder::read(const Track::Track & track, btVector3 & new_position)
{
    new_position = track.get_path().get_node(node_id).get_position();
}

void NodePositionFinder::write(Track::Track & track, const btVector3 & new_position)
{
    Track::Path & path = track.get_path();
    Track::Path::Graph::vertex_descriptor vertex_descriptor = path.get_node_descriptor(node_id);
    Track::PathVertex & vertex = path.graph[vertex_descriptor];
    vertex.set_position(new_position);
    path.update_connected_edges(vertex_descriptor);
}

}
