/** @file libtrack/document/InsertVertexDelta.h
 *  @brief Declare the 
 *  Document::InsertRemoveVertexIdentifier,
 *  Document::InsertVertexDelta,
 *  Document::RemoveVertexDelta, and
 *  Document::RemoveVertexOnlyDelta classes.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef LIBTRACK_DOCUMENT_INSERT_VERTEX_DELTA_H
#define LIBTRACK_DOCUMENT_INSERT_VERTEX_DELTA_H

#include "DocumentDelta.h"

#include "InsertRemoveIdentifier.h"
#include "InsertDelta.h"
#include "RemoveDelta.h"
#include "StackableDelta.h"
#include "../path/PathVertex.h"

namespace Document
{

/** InsertRemoveIdentifier for vertices.
 */
class InsertRemoveVertexIdentifier
    :   InsertRemoveIdentifier<std::size_t, Track::PathVertex>
{
public: 
    InsertRemoveVertexIdentifier(Track::PathVertex object);
    InsertRemoveVertexIdentifier(std::size_t vertex_index);
    
    void insert(Track::Track & track, Track::PathVertex object) const;
    
    Track::PathVertex remove(Track::Track & track) const;
};

/// DocumentDelta to insert a vertex into a track.
typedef InsertDelta<InsertRemoveVertexIdentifier, Track::PathVertex> InsertVertexDelta;
/// DocumentDelta to remove an unconnected vertex in a track.
typedef RemoveDelta<InsertRemoveVertexIdentifier, Track::PathVertex> RemoveVertexOnlyDelta;

/** DocumentDelta which removes a vertex with all associated edges.
 */
class RemoveVertexDelta
    :   public StackableDelta
{
public:
    /** Create associated to a vertex.
     * @param vertex_index The name of the vertex the command should remove.
     */
    RemoveVertexDelta(std::size_t vertex_index);
    virtual void apply(Track::Track & track);
protected:
    std::size_t vertex_index;
};

} // namespace Document

#endif // LIBTRACK_DOCUMENT_INSERT_VERTEX_DELTA_H
