/** @file libtrack/document/InsertTrackAttachmentDelta.h
 *  @brief Declare the 
 *  Document::InsertRemoveTrackAttachmentIdentifier,
 *  Document::InsertTrackAttachmentDelta, and
 *  Document::RemoveTrackAttachmentDelta classes.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef LIBTRACK_DOCUMENT_INSERT_TRACK_ATTACHMENT_DELTA_H
#define LIBTRACK_DOCUMENT_INSERT_TRACK_ATTACHMENT_DELTA_H

#include "DocumentDelta.h"

#include "InsertRemoveIdentifier.h"
#include "InsertDelta.h"
#include "RemoveDelta.h"
#include "../path/PathEdge.h"
#include "../TrackAttachment.h"

namespace Document
{

/** InsertRemoveIdentifier for TrackAttachments.
 */
class InsertRemoveTrackAttachmentIdentifier
    :   public InsertRemoveIdentifier<std::pair<std::size_t, std::size_t>, boost::shared_ptr<Track::TrackAttachment> >
{
public: 
    InsertRemoveTrackAttachmentIdentifier(const boost::shared_ptr<Track::TrackAttachment> & obj);
    InsertRemoveTrackAttachmentIdentifier(std::size_t attachment_name, std::size_t edge_name);
    void insert(Track::Track & track, boost::shared_ptr<Track::TrackAttachment> object) const;
    boost::shared_ptr<Track::TrackAttachment> remove(Track::Track & track) const;
};

/** DocumentDelta to insert a TrackAttachment on an edge.
 */
typedef InsertDelta<InsertRemoveTrackAttachmentIdentifier, boost::shared_ptr<Track::TrackAttachment> > InsertTrackAttachmentDelta;

/** DocumentDelta to remove a TrackAttachment from an edge.
 */
typedef RemoveDelta<InsertRemoveTrackAttachmentIdentifier, boost::shared_ptr<Track::TrackAttachment> > RemoveTrackAttachmentDelta;
    

} // namespace Document

#endif // LIBTRACK_DOCUMENT_INSERT_TRACK_ATTACHMENT_DELTA_H
