/** @file libtrack/document/InsertTrackAttachmentDelta.cpp
 *  @brief Implement the 
 *  Document::InsertRemoveTrackAttachmentIdentifier,
 *  Document::InsertTrackAttachmentDelta, and
 *  Document::RemoveTrackAttachmentDelta classes.
 *  @author James Legg
 */
/* Copyright © 2009, 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "InsertTrackAttachmentDelta.h"
#include "../Track.h"
#include <Debug.h>

namespace Document
{

InsertRemoveTrackAttachmentIdentifier::InsertRemoveTrackAttachmentIdentifier(const boost::shared_ptr<Track::TrackAttachment> & obj)
    :   InsertRemoveIdentifier<std::pair<std::size_t, std::size_t>, boost::shared_ptr<Track::TrackAttachment> >
            (std::pair<std::size_t, std::size_t>(obj->get_name(), obj->edge_name))
{
}

InsertRemoveTrackAttachmentIdentifier::InsertRemoveTrackAttachmentIdentifier(std::size_t attachment_name, std::size_t edge_name)
    :   InsertRemoveIdentifier<std::pair<std::size_t, std::size_t>, boost::shared_ptr<Track::TrackAttachment> >
            (std::pair<std::size_t, std::size_t>(attachment_name, edge_name))
{
}

void InsertRemoveTrackAttachmentIdentifier::insert(Track::Track & track, boost::shared_ptr<Track::TrackAttachment> object) const
{
    // insert.
    // First check if we are adding the right object.
    assert((object->get_name() == identifier.first));
    track.get_path().get_edge(identifier.second).insert_attachment(object);
}

boost::shared_ptr<Track::TrackAttachment> InsertRemoveTrackAttachmentIdentifier::remove(Track::Track & track) const
{
    // remove but return a copy.
    typedef std::vector<boost::shared_ptr<Track::TrackAttachment> > VectorType;
    Track::PathEdge & edge = track.get_path().get_edge(identifier.second);
    const VectorType & vector = edge.get_attachments();
    for (VectorType::const_iterator it = vector.begin();
         it != vector.end();
         it++)
    {
        if ((**it).get_name() == identifier.first)
        {
            boost::shared_ptr<Track::TrackAttachment> ptr = (*it);
            edge.remove_attachment(identifier.first);
            return ptr;
        }
    }
    // could not be found. Editor's state is broken.
    assert(false);
}

} // namespace Document
