/** @file libtrack/document/InsertRemoveIdentifier.h
 *  @brief Declare the Document::InsertRemoveIdentifier class. 
 *  @author James Legg
 */
/* Copyright © 2009, 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef LIBTRACK_DOCUMENT_INSERT_REMOVE_IDENTIFIER_H
#define LIBTRACK_DOCUMENT_INSERT_REMOVE_IDENTIFIER_H

#include "DocumentDelta.h"

namespace Document
{

/** Base class that adds or removes an object with a fixed identity.
 * @tparam Identifier class describing the identity of the object.
 * @tparam ObjectType the class that is added or removed.
 */
template <class Identifier, class Object>
class InsertRemoveIdentifier
{
public: 
    /// Create keeping the identifier from an object.
    InsertRemoveIdentifier(Object object)
    {
    }
    
    /// Create keeping an explicitly found identifier.
    InsertRemoveIdentifier(Identifier identifier)
        :   identifier(identifier)
    {
    }
    
    virtual ~InsertRemoveIdentifier()
    {
    }
    
    /// Insert an object into a Track::Track.
    virtual void insert(Track::Track & track, Object object) const = 0;
    
    /// Remove an object from a Track::Track.
    virtual Object remove(Track::Track & track) const = 0;
    
protected:
    /// Associated object identity.
    Identifier identifier;
};

} // namespace Document

#endif // LIBTRACK_DOCUMENT_INSERT_REMOVE_IDENTIFIER_H
