/** @file libtrack/document/InsertEdgeDelta.h
 *  @brief Declare the 
 *  Document::InsertRemoveEdgeIdentifier,
 *  Document::InsertEdgeDelta, and
 *  Document::RemoveEdgeDelta classes
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef LIBTRACK_DOCUMENT_INSERT_EDGE_DELTA_H
#define LIBTRACK_DOCUMENT_INSERT_EDGE_DELTA_H

#include "DocumentDelta.h"

#include "InsertRemoveIdentifier.h"
#include "InsertDelta.h"
#include "RemoveDelta.h"
#include "../path/PathEdge.h"

namespace Document
{

/** InsertRemoveIdentifier for edges.
 */
class InsertRemoveEdgeIdentifier
    :   InsertRemoveIdentifier<std::size_t, Track::PathEdge>
{
public: 
    InsertRemoveEdgeIdentifier(Track::PathEdge object);
    InsertRemoveEdgeIdentifier(std::size_t edge_index);
    
    void insert(Track::Track & track, Track::PathEdge object) const;
    
    Track::PathEdge remove(Track::Track & track) const;
};

/// DocumentDelta to insert a vertex into a track.
typedef InsertDelta<InsertRemoveEdgeIdentifier, Track::PathEdge> InsertEdgeDelta;
/// DocumentDelta to remove an unconnected vertex in a track.
typedef RemoveDelta<InsertRemoveEdgeIdentifier, Track::PathEdge> RemoveEdgeDelta;

} // namespace Document

#endif // LIBTRACK_DOCUMENT_INSERT_EDGE_DELTA_H
