/** @file libtrack/document/InsertEdgeDelta.cpp
 *  @brief Implement the 
 *  Document::InsertRemoveEdgeIdentifier,
 *  Document::InsertEdgeDelta, and
 *  Document::RemoveEdgeDelta classes
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "InsertEdgeDelta.h"
#include "../Track.h"

#include <Debug.h>

namespace Document
{

InsertRemoveEdgeIdentifier::InsertRemoveEdgeIdentifier(Track::PathEdge object)
    :   InsertRemoveIdentifier<std::size_t, Track::PathEdge>(object.get_name())
{
}

InsertRemoveEdgeIdentifier::InsertRemoveEdgeIdentifier(std::size_t edge_index)
    :   InsertRemoveIdentifier<std::size_t, Track::PathEdge>(edge_index)
{
}

void InsertRemoveEdgeIdentifier::insert(Track::Track & track, Track::PathEdge object) const
{
    assert(identifier == object.get_name());
    // find which vertices to attach to.
    typedef Track::Path::Graph::vertex_descriptor VertexDescriptor;
    Track::Path & path = track.get_path();
    Track::Path::Graph & graph = path.graph;
    VertexDescriptor source = path.get_node_descriptor(object.get_start_vertex_name());
    VertexDescriptor target = path.get_node_descriptor(object.get_finish_vertex_name());
    boost::add_edge(source, target, object, graph);
}

Track::PathEdge InsertRemoveEdgeIdentifier::remove(Track::Track & track) const
{
    /// @todo When objects can be placed on the edges, check there are none.
    // remove the associated edge.
    Track::Path & path = track.get_path();
    Track::Path::Graph & graph = path.graph;
    Track::Path::Graph::edge_descriptor edge_descriptor = path.get_edge_descriptor(identifier);
    Track::PathEdge edge = graph[edge_descriptor];
    boost::remove_edge(edge_descriptor, graph);
    return edge;
}

} // namespace Document
