/** @file libtrack/document/InsertDelta.h
 *  @brief Declare the Document::InsertDelta class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef LIBTRACK_DOCUMENT_INSERT_DELTA_H
#define LIBTRACK_DOCUMENT_INSERT_DELTA_H

#include "DocumentDelta.h"

namespace Document
{

/** Class to create an object in a Track.
 * @tparam InsertRemoveIdentifer class to identify an object and insert or
 * remove it. Should behave like a Document::InsertRemoveIdentifier.
 * @tparam Object the class of object that is added and removed.
 */
template <class InsertRemoveIdentifer, class Object>
class InsertDelta
    :   public DocumentDelta
{
public:
    /** Create a delta instructing the addition of the object.
     */
    InsertDelta(const Object & object)
        :   object(object)
        ,   identifier(object)
    {
    }
    
    virtual ~InsertDelta()
    {
    }
    
    /// Insert the object into a track
    virtual void apply(Track::Track & track)
    {
        identifier.insert(track, object);
    }
    
    /// Remove it again.
    virtual void unapply(Track::Track & track)
    {
        identifier.remove(track);
    }
protected:
    Object object;
    InsertRemoveIdentifer identifier;
};

} // namespace Document

#endif // LIBTRACK_DOCUMENT_INSERT_DELTA_H
