/** @file document/FlipEdgeDelta.h
 *  @brief Declare the Document::FlipEdgeDelta class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef LIBTRACK_DOCUMENT_FLIP_EDGE_DELTA_H_
#define LIBTRACK_DOCUMENT_FLIP_EDGE_DELTA_H_

#include "SymmetricDelta.h"

#include <cstddef>

namespace Document
{

/** Flip the start and finish ends of a edge.
 * The resulting edge takes the same path but the mesh is tiled in other
 * direction.
 */
class FlipEdgeDelta
    :   public SymmetricDelta
{
public:
    FlipEdgeDelta(std::size_t edge_name);
    virtual ~FlipEdgeDelta();
    
    void apply(Track::Track & track);
protected:
    std::size_t edge_name;
};

} // namespace Document

#endif // LIBTRACK_DOCUMENT_FLIP_EDGE_DELTA_H_
