/** @file document/FlipEdgeDelta.cpp
 *  @brief Implement the Document::FlipEdgeDelta class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "FlipEdgeDelta.h"
#include "../Track.h"
#include "InsertEdgeDelta.h"

namespace Document
{

FlipEdgeDelta::FlipEdgeDelta(std::size_t edge_name)
    :   edge_name(edge_name)
{
}

FlipEdgeDelta::~FlipEdgeDelta()
{
}

void FlipEdgeDelta::apply(Track::Track & track)
{
    Track::Path & path = track.get_path();
    Track::Path::Graph & graph = path.graph;
    Track::Path::Graph::edge_descriptor edge_descriptor = path.get_edge_descriptor(edge_name);
    Track::PathEdge & edge = graph[edge_descriptor];
    Track::PathEdge new_edge = edge;
    // swap stuff over.
    new_edge.start = Track::PathEdgeEnd(edge_name, Track::EditAssist::EdgeStrengthHandle::EE_SOURCE);
    new_edge.start.gradient_strength = edge.finish.gradient_strength;
    new_edge.start.segment_connection_index = edge.finish.segment_connection_index;
    
    new_edge.finish = Track::PathEdgeEnd(edge_name, Track::EditAssist::EdgeStrengthHandle::EE_DESTINATION);
    new_edge.finish.gradient_strength = edge.start.gradient_strength;
    new_edge.finish.segment_connection_index = edge.start.segment_connection_index;
    
    new_edge.update(edge.get_finish_vertex_name(), edge.get_start_vertex_name(), &path);
    InsertEdgeDelta(new_edge).apply(track);
    RemoveEdgeDelta(InsertRemoveEdgeIdentifier(edge_name)).apply(track);
}

} // namespace Document
