/** @file document/DocumentDelta.h
 *  @brief Declare the Document::DocumentDelta class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef DOCUMENT_DELTA_H_
#define DOCUMENT_DELTA_H_

namespace Track
{
    class Track;
}

namespace Document
{

/** Abstract base class for changes that can be made to a track.
 */
class DocumentDelta
{
public:
    DocumentDelta();
    virtual ~DocumentDelta();
    
    /** Perform the associated reverable action on the track.
     * @param track The track to apply the changes to.
     */
    virtual void apply(Track::Track & track) = 0;
    
    /** Reverse the action.
     * This will only be called when the track is in the same state having just
     * called @code apply(track) @endcode , and must take the track back to the
     * state it was in before calling apply.
     * @param track The track to apply the changes to.
     */
    virtual void unapply(Track::Track & track) = 0;
};

}

#endif // DOCUMENT_DELTA_H_
