/** @file document/ClearVertexDelta.h
 *  @brief Declare the Document::ClearVertexDelta class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef LIBTRACK_DOCUMENT_CLEAR_VERTEX_DELTA_H_
#define LIBTRACK_DOCUMENT_CLEAR_VERTEX_DELTA_H_

#include "StackableDelta.h"

namespace Document
{
    
/** Delta which deletes all edges attached to a vertex.
 */
class ClearVertexDelta
    :   public StackableDelta
{
public:
    /// Construct giving vertex to clear.
    ClearVertexDelta(std::size_t vertex_name);
    void apply(Track::Track & track);
protected:
    std::size_t vertex_name;
};

} // namespace document

#endif // LIBTRACK_DOCUMENT_CLEAR_VERTEX_DELTA_H_
