/** @file document/ClearVertexDelta.cpp
 *  @brief Implement the Document::ClearVertexDelta class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "ClearVertexDelta.h"
#include "InsertEdgeDelta.h"
#include "../Track.h"

namespace Document
{

ClearVertexDelta::ClearVertexDelta(std::size_t vertex_name)
    :   vertex_name(vertex_name)
{
}

void ClearVertexDelta::apply(Track::Track & track)
{
    Track::Path & path = track.get_path();
    Track::Path::Graph & graph = path.graph;
    Track::Path::Graph::vertex_descriptor vertex_descriptor = path.get_node_descriptor(vertex_name);
    
    // remove out edges.
    typedef Track::Path::Graph::out_edge_iterator out_edge_iterator;
    std::pair<out_edge_iterator, out_edge_iterator> out_edges;
    while (boost::out_degree(vertex_descriptor, graph))
    {
        out_edges = boost::out_edges(vertex_descriptor, graph);
        std::size_t edge_name = graph[*(out_edges.first)].get_name();
        boost::shared_ptr<DocumentDelta> delta(new RemoveEdgeDelta(edge_name));
        add_to_stack(delta, track);
    }
    
    // remove in edges
    typedef Track::Path::Graph::in_edge_iterator in_edge_iterator;
    std::pair<in_edge_iterator, in_edge_iterator> in_edges;
    while (boost::in_degree(vertex_descriptor, graph))
    {
        in_edges = boost::in_edges(vertex_descriptor, graph);
        std::size_t edge_name = graph[*(in_edges.first)].get_name();
        boost::shared_ptr<DocumentDelta> delta(new RemoveEdgeDelta(edge_name));
        add_to_stack(delta, track);
    }
}

} // namespace document
