/** @file document/ChangeVertexSegmentDelta.cpp
 *  @brief Implement the Document::ChangeVertexSegmentDelta class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "ChangeVertexSegmentDelta.h"
#include "../Track.h"
#include "ClearVertexDelta.h"

namespace Document
{

VertexSegmentFinder::VertexSegmentFinder(std::size_t node_id)
    :   node_id(node_id)
{
}

void VertexSegmentFinder::read(const Track::Track & track, std::size_t & new_segment_index)
{
    new_segment_index = track.get_path().get_node(node_id).get_segment_index();
}

void VertexSegmentFinder::write(Track::Track & track, const std::size_t & new_segment_index)
{
    Track::Path & path = track.get_path();
    Track::PathVertex & vertex = path.get_node(node_id);
    // set the new segment.
    vertex.set_segment(new_segment_index,
                       &track.get_theme().get_segment(new_segment_index));
}

std::size_t VertexSegmentFinder::get_vertex_name() const
{
    return node_id;
}

ChangeVertexSegmentDelta::ChangeVertexSegmentDelta(VertexSegmentFinder vertex_segment_finder, std::size_t new_segment_index)
    :   vertex_segment_finder(vertex_segment_finder)
    ,   new_segment_index(new_segment_index)
{
}
    
void ChangeVertexSegmentDelta::apply(Track::Track & track)
{
    // remove attached edges.
    std::size_t vertex_name = vertex_segment_finder.get_vertex_name();
    boost::shared_ptr<DocumentDelta> clear_delta(
        new ClearVertexDelta(vertex_name)
    );
    add_to_stack(clear_delta, track);
    
    // change the vertex's segment
    boost::shared_ptr<DocumentDelta> change_segment_delta(
        new ChangeVertexSegmentOnlyDelta(vertex_segment_finder,
                                         new_segment_index)
    );
    add_to_stack(change_segment_delta, track);
}

}
