/** @file libtrack/document/ChangeLightingDelta.h
 *  @brief Declare the Document::ChangeLightingDelta class. 
 *  @author James Legg
 */
/* Copyright © 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef LIBTRACK_DOCUMENT_CHANGE_LIGHTING_DELTA_H_
#define LIBTRACK_DOCUMENT_CHANGE_LIGHTING_DELTA_H_

#include "DocumentDelta.h"
#include "../Lighting.h"

namespace Document
{

/** A DocumentDelta to change a Track::Track's Track::Lighting object to another one.
 */
class ChangeLightingDelta
    :   public DocumentDelta
{
public:
    /** Construct using specified replacement lighting.
     * @param new_lighting The Track::Lighting that will replace the current
     * track's lighting when the delta is applied.
     */
    ChangeLightingDelta(Track::Lighting new_lighting);
    /** Change the lighting to the one specified in the constructor.
     * @param track The track to apply the changes to.
     */
    virtual void apply(Track::Track & track);
    
    /** Revert to the original lighting.
     * @param track The track to apply the changes to.
     */
    virtual void unapply(Track::Track & track);
protected:
    Track::Lighting m_new_lighting;
    Track::Lighting m_old_lighting;
};

} // namespace Document

#endif // LIBTRACK_DOCUMENT_CHANGE_LIGHTING_DELTA_H_
