/** @file libtrack/document/ChangeLightingDelta.cpp
 *  @brief Implement the Document::ChangeLightingDelta class. 
 *  @author James Legg
 */
/* Copyright © 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "ChangeLightingDelta.h"
#include "../Track.h"

namespace Document
{

ChangeLightingDelta::ChangeLightingDelta(Track::Lighting new_lighting)
    :   m_new_lighting(new_lighting)
{
}

void ChangeLightingDelta::apply(Track::Track & track)
{
    m_old_lighting = track.get_lighting();
    track.set_lighting(m_new_lighting);
}

void ChangeLightingDelta::unapply(Track::Track & track)
{
    track.set_lighting(m_old_lighting);
}

} // namespace Document
