/** @file document/ChangeEdgeSegmentDelta.h
 *  @brief Declare the Document::ChangeEdgeSegmentDelta class. 
 *  @author James Legg
 */
/* Copyright © 2009, 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef CHANGE_EDGE_SEGMENT_DELTA_H_
#define CHANGE_EDGE_SEGMENT_DELTA_H_

#include <cstddef>

#include "ChangePropertyDelta.h"

namespace Document
{

/** Find/change the segment associated with a particular edge.
 */
class EdgeSegmentFinder : public PropertyDeltaIdentifier<std::size_t>
{
public:
    /** Create associating with an edge.
     * @param edge_id The name of the edge to read and write the segment for.
     */
    EdgeSegmentFinder(std::size_t edge_id);
    /** Read the segment_index of the associated edge.
     * @param track The track containing the associated edge.
     * @param segment_index Variable to store the segment index in.
     */
    virtual void read(const Track::Track & track, std::size_t & segment_index);
    /** Write a segment_index to the associated edge.
     * @param track The track containing the associated edge.
     * @param new_segment_index The new segment index to assign.
     */
    virtual void write(Track::Track & track, const std::size_t & new_segment_index);
protected:
    /// The name of the associated edge.
    std::size_t edge_id;
};

/** Command for switching the segment along an edge in a path.
*/
typedef ChangePropertyDelta<EdgeSegmentFinder, std::size_t> ChangeEdgeSegmentDelta;

}

#endif // CHANGE_EDGE_SEGMENT_DELTA_H_
