/** @file document/ChangeEdgeSegmentDelta.cpp
 *  @brief Implement the Document::ChangeEdgeSegmentDelta class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "ChangeEdgeSegmentDelta.h"
#include "../Track.h"

namespace Document
{

EdgeSegmentFinder::EdgeSegmentFinder(std::size_t edge_id)
    :   edge_id(edge_id)
{
}

void EdgeSegmentFinder::read(const Track::Track & track, std::size_t & new_segment_index)
{
    new_segment_index = track.get_path().get_edge(edge_id).segment_index;
}

void EdgeSegmentFinder::write(Track::Track & track, const std::size_t & new_segment_index)
{
    Track::Path & path = track.get_path();
    Track::PathEdge & edge = path.get_edge(edge_id);
    // set the new segment.
    edge.segment_index = new_segment_index;
    edge.segment = &track.get_theme().get_segment(new_segment_index);
    edge.update();
}

}
