/** @file libtrack/TrackBooster.h
 *  @brief Declare the Track::TrackBooster class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef LIBTRACK_TRACK_BOOSTER_H_
#define LIBTRACK_TRACK_BOOSTER_H_

#include "TrackAttachment.h"

#include <LinearMath/btVector3.h>

namespace Track
{

/** A booster attached to the track.
 */
class TrackBooster
    :   public TrackAttachment
{
public:
    TrackBooster(std::istream & source);
    TrackBooster();
    virtual ~TrackBooster();
    virtual std::string get_class_identifier() const;
    virtual void draw() const;
    virtual void add_data(std::ostream & stream) const;
protected:

};

std::ostream & operator<<(std::ostream & destination, TrackBooster booster);

} // namespace Track


#endif // LIBTRACK_TRACK_BOOSTER_H_
