/** @file libtrack/TrackBooster.cpp
 *  @brief Implement the Track::TrackBooster class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "TrackBooster.h"
#include "FormErrors.h"
#include "Mesh/DrawableMesh.h"
#include "Texture.h"

#include <GL/gl.h>

namespace Track
{

std::string TrackBooster::get_class_identifier() const
{
    return std::string("Track::TrackBooster");
}

const unsigned int latest_track_booster_version = 1;

TrackBooster::TrackBooster(std::istream & source)
    :   TrackAttachment(source)
{
    unsigned int version;
    source >> version;
    if (version < latest_track_booster_version) throw DepreciatedVersionError();
    if (version > latest_track_booster_version) throw NewVersionError();
    
}

TrackBooster::TrackBooster()
{
}

TrackBooster::~TrackBooster()
{
}

void TrackBooster::draw() const
{
    static DrawableMesh booster("data/generic/booster");
    static Texture texture("data/generic/booster.png");
    texture.bind();
    booster.draw();
}

void TrackBooster::add_data(std::ostream & stream) const
{
    TrackAttachment::add_data(stream);
    stream << ' ' << latest_track_booster_version;
}

std::ostream & operator<<(std::ostream & destination, TrackBooster booster)
{
}

} // namespace Track
