/** @file libtrack/TrackAttachment.cpp
 *  @brief Implement the Track::TrackAttachment class. 
 *  @author James Legg
 */
/* Copyright © 2009, 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "TrackAttachment.h"
#include "FormErrors.h"

namespace Track
{

std::string TrackAttachment::get_class_identifier() const
{
    return std::string ("Track::TrackAttachment");;
}

const unsigned int latest_track_attachment_file_version = 2;

TrackAttachment::TrackAttachment(std::istream & source)
{
    unsigned int version;
    source >> version;
    if (version == 1)
    {
        m_vertical_position = 0;
    }
    else if (version < latest_track_attachment_file_version)
    {
        throw DepreciatedVersionError();
    }
    else if (version > latest_track_attachment_file_version)
    {
        throw NewVersionError();
    }
    source >> m_t_position;
    source >> m_lateral_position;
    if (version > 1)
    {
        source >> m_vertical_position;
    }
}

TrackAttachment::TrackAttachment()
    :   m_t_position(0)
    ,   m_lateral_position(0)
    ,   m_vertical_position(0)
{
}

TrackAttachment::~TrackAttachment()
{
}

btScalar TrackAttachment::get_t_position() const
{
    return m_t_position;
}

void TrackAttachment::set_t_position(btScalar value)
{
    m_t_position = value;
}

btScalar TrackAttachment::get_lateral_position() const
{
    return m_lateral_position;
}

void TrackAttachment::set_lateral_position(btScalar value)
{
    m_lateral_position = value;
}

btScalar TrackAttachment::get_vertical_position() const
{
    return m_vertical_position;
}

void TrackAttachment::set_vertical_position(btScalar value)
{
    m_vertical_position = value;
}

void TrackAttachment::add_data(std::ostream & destination) const
{
    destination << latest_track_attachment_file_version << " "
                << m_t_position << " "
                << m_lateral_position << " "
                << m_vertical_position;
}

void TrackAttachment::draw() const
{
}

void TrackAttachment::set_global_transform(btTransform tansform)
{
    m_global_transform = tansform;
}

const btTransform & TrackAttachment::get_global_transform() const
{
    return m_global_transform;
}

std::ostream & operator<<(std::ostream & destination, const TrackAttachment & attachment)
{
    attachment.add_data(destination);
}


} // namespace Track
