/** @file libtrack/StartingPosition.h
 *  @brief Declare the Track::StartingPosition class. 
 *  @author James Legg
 */
/* Copyright © 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef LIBTRACK_STARTING_POSITION_H_
#define LIBTRACK_STARTING_POSITION_H_

#include "TrackAttachment.h"

#include <LinearMath/btVector3.h>

namespace Track
{

/** The marker where cars start the race from.
 */
class StartingPosition
    :   public TrackAttachment
{
public:
    StartingPosition(std::istream & source);
    
    /** Create starting position with rank 0.
     */
    StartingPosition();
    
    /** Create starting position for a rank.
     * @param rank The starting rank. 0 is first infront of the line.
     */
    StartingPosition(unsigned int rank);
    
    virtual ~StartingPosition();
    
    virtual std::string get_class_identifier() const;
    virtual void draw() const;
    virtual void add_data(std::ostream & stream) const;
    
    /// Return the rank of this starting position.
    unsigned int get_rank() const;
protected:
    /** rank from 0 of the starting position.
     * 0 is the rank for the starting position closest to the start line.
     */
    unsigned int m_rank;
};

std::ostream & operator<<(std::ostream & destination, StartingPosition starting_position);

} // namespace Track


#endif // LIBTRACK_STARTING_POSITION_H_
