/** @file libtrack/Skybox.h
 *  @brief Declare the Track::Skybox class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef LIBTRACK_SKYBOX_H_
#define LIBTRACK_SKYBOX_H_

#include <vector>
#include <istream>

#include <boost/shared_ptr.hpp>

#include "Texture.h"

namespace Track
{

/** basic skybox that can be loaded from a input stream.
 */ 
class Skybox
{
public:
    Skybox(std::istream & source);
    Skybox();
    virtual ~Skybox();
protected:
    std::vector<boost::shared_ptr<Texture> > textures;
};

}

#endif /*LIBTRACK_SKYBOX_H_*/
