/** @file libtrack/Skybox.cpp
 *  @brief Implement the Track::Skybox class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#include "Skybox.h"

#include "stream_loader.h"

namespace Track
{

Skybox::Skybox(std::istream & source)
{
    fill_vector_from_stream(textures, source);
    // debug builds, check right number of textures.
    assert(textures.size() == 6);
    // It is a theme file error even in a non debug build:
    if (textures.size() != 6)
    {
        throw;
    }
}

Skybox::Skybox()
{
}

Skybox::~Skybox()
{
}

}
