/** @file libtrack/SegmentConnection.cpp
 *  @brief Implement the Track::SegmentConnection class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#include "SegmentConnection.h"
#include <Debug.h>

namespace Track
{

SegmentConnection::SegmentConnection(unsigned int cross_section_id,
                                     btTransform transform)
    : cross_section_id(cross_section_id)
    , transform(transform)
{
}

SegmentConnection::SegmentConnection(std::istream & source)
{
    // get id.
    source >> cross_section_id;
    
    btScalar x, y, z, w;
    // get origin
    source >> x >> y >> z;
    transform.setOrigin(btVector3(x, y, z));
    // get rotation
    source >> x >> y >> z >> w;
    DEBUG_MESSAGE("Segment connection quaternion: (" << x << ", " << y << ", " << ", " << z << ", " << w << ")");
    transform.setRotation(btQuaternion(x, y, z, w));
}

SegmentConnection::~SegmentConnection()
{
}

unsigned int SegmentConnection::get_cross_section_id() const
{
    return cross_section_id;
}

const btTransform & SegmentConnection::get_transform() const
{
    return transform;
}

}
