/** @file libtrack/PieceDistortion.h
 *  @brief Declare the Track::PieceDistortion class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef LIBTRACK_PIECEDISTORTION_H_
#define LIBTRACK_PIECEDISTORTION_H_

#include <LinearMath/btVector3.h>

namespace Track
{

class PathEdge;
class PathVertex;

/// defines the transformation that can be put on a single mesh piece of a track.  
class PieceDistortion
{
public:
    PieceDistortion();
    /** Create, initalising componets.
     * @param edge The edge information for the arc the segment lies on.
     * @param number Which segment in the repetitions along the edge, starting
     * from 0.
     * @param length The length of the segment in the y direction.
     * @param min_y The smallest y value in the segment.
     */
    PieceDistortion(const PathEdge & edge,
                    unsigned int number, btScalar length, btScalar min_y);
    virtual ~PieceDistortion();
    
    const PathEdge & edge;
    
    unsigned int number;
    btScalar length;
    btScalar min_y;
    
    /// distort a single vertex
    btVector3 operator()(btVector3 vertex);
protected:
    
};

}

#endif /*LIBTRACK_PIECEDISTORTION_H_*/
