/** @file libtrack/PieceDistortion.cpp
 *  @brief Implement the Track::PieceDistortion class.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#include "PieceDistortion.h"
#include "path/Path.h"

namespace Track
{

PieceDistortion::PieceDistortion(const PathEdge & edge,
                                 unsigned int number,
                                 btScalar length,
                                 btScalar min_y)
    :   edge(edge)
    ,   number(number)
    ,   length(length)
    ,   min_y(min_y)
{
    
}

PieceDistortion::~PieceDistortion()
{
}

btVector3 PieceDistortion::operator()(btVector3 vertex)
{
    btScalar position = ((vertex.y() - min_y) / length + number) / edge.get_number_of_repetions();
    vertex.setY(0);
    return edge.get_transform(position)(vertex);
}

}
