/** @file OcclusionTester.cpp
 *  @brief Implement the Track::OcclusionTester class.
 *  @author James Legg
 */
/* Copyright © 2009, 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#include "OcclusionTester.h"

namespace Track
{


OcclusionTester::OcclusionTester()
{
}

OcclusionTester::~OcclusionTester()
{
}

OcclusionTester::ViewState OcclusionTester::operator ()(const Track::AxisAlignedBoundingBox & aabb) const
{
    /* If all vertices are the wrong side of the same plane, then the aabb is
     * outside of the view. If all vertices are inside the viewing area, the
     * whole aabb is inside the viewing area. In any other case, we may have
     * no overlap or partial overlap.
     */
    unsigned passed(0);
    btVector3 min = aabb.get_min();
    btVector3 max = aabb.get_max();
    for (unsigned plane_index = 0; plane_index < 5; plane_index++)
    {
        unsigned passed_this_plane(0);
        for (unsigned int i = 0; i < 2; i++)
        {
            for (unsigned int j = 0; j < 2; j++)
            {
                for (unsigned int k = 0; k < 2; k++)
                {
                    if (in_half_space(btVector3(i ? min.x() : max.x(),
                                                j ? min.y() : max.y(),
                                                k ? min.z() : max.z()
                                                ),
                                      plane_index))
                    {
                        passed_this_plane++;
                    }
                }
            }
        }
        if (passed_this_plane == 0)
        {
            // all on one side, so entire volume is outside.
            return VS_OUT;
        }
        passed += passed_this_plane;
    }
    if (passed == 40)
    {
        // all points inside all half spaces. aabb is completely inside.
        return VS_IN;
    }
    /** @todo more testing. It could be outside still, if partially inside
     * two half spaces.
     */
    return VS_PARTIAL;
}

inline bool OcclusionTester::in_half_space(const btVector3 & point, const unsigned plane_index) const
{
    return point.dot(plane_vectors[plane_index]) +
           plane_distances[plane_index] > 0;
}

}
