/** @file libtrack/FormErrors.h
 *  @brief Declare the classes that can be thrown when there are errors loading
 * data.
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef LIBTRACK_FORM_ERRORS_H_
#define LIBTRACK_FORM_ERRORS_H_

/// An error in the form of the input.
class FormError
{};

/// Error when a track refers to something that does not exist in a theme.
class ThemeChangedError
    :   public FormError
{};

/// Error when the input is inconsistant with itself.
class CorruptedError
    :   public FormError
{};

/// Error when a class is using a version not supported.
class VersionError
    :   public FormError
{};

/// Error when a file requests a version exceeding the latest we know how to process. 
class NewVersionError
    :   public VersionError
{};

/// Error when an object type is not known
class UnkownObjectError
    :   public NewVersionError
{};

/// Error when an object type does not convert to something compatible with its container.
class WrongTypeError
    :   public CorruptedError
{};

/// Error when a file requests a version preceeding the earliest supported version.
class DepreciatedVersionError
    :   public VersionError
{};

#endif
