/** @file libtrack/Drawable.h
 *  @brief Declare the Track::Drawable class. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef LIBTRACK_DRAWABLE_H_
#define LIBTRACK_DRAWABLE_H_

#include "OcclusionTester.h"

namespace Track
{

/** Base clase for anything which can be drawn in game.
 */
class Drawable
{
public:
    Drawable();
    virtual ~Drawable();
    
    /** Draw the object.
     * Called indirectly by draw(const OcclusionTester &) const when it is on
     * the screen, but can also be called manually if view bounds are not
     * known.
     */
    virtual void draw() const = 0;
    
    /** Draw the object if it is visible.
     * @param occlusion_tester Reference to object describing planes of the
     * view's frustrum to test against.
     */
    virtual void conditional_draw(const OcclusionTester & occlusion_tester) const;
};

}

#endif /*LIBTRACK_DRAWABLE_H_*/
