/** @file Debug.h
 *  @brief Define some useful symbols for debugging.
 *  In release build (where NDEBUG is defined) these work quite differently. 
 *  @author James Legg
 */
/* Copyright © 2009 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef DEBUG_H_
#define DEBUG_H_

#include <cassert>
#include <iostream>
#ifdef NDEBUG
    // no-op for release build
    #define DEBUG_MESSAGE( text )
#else
    #include <iostream> 
    #define DEBUG_MESSAGE( text ) \
        std::cout << "Debug message: (from " __FILE__ ":" << __LINE__ << ") "\
                  << text << std::endl
#endif

// hopefully this won't get into the release build, but would still be useful.
#define PRINT_STUB_MESSAGE \
    std::cout << "Not implemented yet: " __FILE__ ":" << __LINE__ << std::endl

// a build time macro for versioning.
#define BUILD_TIME __DATE__ __TIME__
 
#endif /*DEBUG_H_*/
