/** @file libtrack/DataCheck.h
 *  @brief Declare the Track::DataCheck class.
 *  @author James Legg
 */
/* Copyright © 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#ifndef LIBTRACK_DATA_CHECK_H
#define LIBTRACK_DATA_CHECK_H

#include <string>

namespace Track
{

/** Make sure we can access necessary data files.
 */
class DataCheck
{
    public:
        /** Error for an inaccessible file.
         */
        class FileMissingError
        {
            public:
                /// The relative path of the file which cannot be found.
                std::string filename;
        };
        
        /// Throws an error if files are missing.
        DataCheck();
    private:
        /// Throw error if file is missing.
        void check_file(std::string filename);
        
        /** Check for a file in a full path.
         * Sets the path as the current working directory if it works.
         * @return true if it works, false if it doesn't.
         */
        bool check_directory(std::string path);
        
        /** Check for a file in a path relative to the working directory.
         * Sets the full path as the current working directory if it works.
         * @return true if it works, false if it doesn't.
         */
        bool check_relative_directory(std::string path);
};

} // namespace Track

#endif // LIBTRACK_DATA_CHECK_H
