/** @file libtrack/ClassLoader.cpp
 *  @brief Implement the Track::SaveableClassList classe.
 *  @author James Legg
 */
/* Copyright © 2009, 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "ClassLoader.h"

#include "TrackAttachment.h"
#include "StartingPosition.h"
#include "TrackBooster.h"

namespace Track
{

void register_all_classes_with_savable_class_list()
{
    // I don't like having a big list here, but if these are declared in the
    // source file their class uses, then they might not be initalized ever.
    static ClassLoader<TrackAttachment> track_attachment(TrackAttachment().get_class_identifier());
    static ClassLoader<StartingPosition> starting_position(StartingPosition().get_class_identifier());
    static ClassLoader<TrackBooster> track_booster(TrackBooster().get_class_identifier());
}

SaveableClassList::SaveableClassList()
{
}

SaveableClassList * SaveableClassList::get_instance()
{
    static SaveableClassList * the_savable_class_list_instance = new SaveableClassList();
    return the_savable_class_list_instance;
}

}
