/** @file libtrack/AABBDrawable.h
 *  @brief Declare the Track::AABBDrawable class.
 *  @author James Legg
 */
/* Copyright © 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/
#ifndef LIBTRACK_AABB_DRAWABLE_H
#define LIBTRACK_AABB_DRAWABLE_H

#include "Drawable.h"
#include "AxisAlignedBoundingBox.h"

namespace Track
{

/** A drawable with an axis aligned bounding box.
 * The bounding box can be used to detect if it is worth drawing.
 */
class AABBDrawable
    :   virtual public Drawable
    ,   virtual public AABBBounded
{
    public:
        /** Draw the object if any part of its bounding box is in view.
         */
        virtual void conditional_draw(const OcclusionTester & occlusion_tester) const;
};

} // namespace Track

#endif // LIBTRACK_AABB_DRAWABLE_H
