/** @file libtrack/AABBDrawable.cpp
 *  @brief Implement the Track::AABBDrawable class.
 *  @author James Legg
 */
/* Copyright © 2010 James Legg.
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
*/

#include "AABBDrawable.h"

namespace Track
{

void AABBDrawable::conditional_draw(const OcclusionTester & occlusion_tester) const
{
    if (occlusion_tester(get_bounds()) != OcclusionTester::VS_OUT)
    {
        draw();
    }
}

} // namespace Track
