#include "math.h"

//#include "zmath.h"
#include "stdlib.h"
#include "vars.h"
#define FPDIV(x,y)	((((x)<<12)/((y)))>>4)

Uint8 table_rnd[1024]={30,193,252,152,70,237,135,54,35,249,126,200,86,176,108,172,
218,181,240,108,218,165,105,134,82,227,126,46,197,251,103,157,
192,165,243,101,79,13,69,134,250,247,94,26,68,156,38,36,
59,217,31,131,233,23,253,52,182,100,39,74,219,118,124,144,
37,137,225,94,55,114,9,20,66,148,45,112,187,47,45,43,
108,0,4,38,90,44,98,24,110,118,78,235,71,23,226,172,
252,153,44,226,27,190,184,228,186,51,149,175,156,3,6,4,
146,56,238,208,116,135,68,78,176,113,154,95,147,50,10,174,
57,197,203,34,209,62,137,245,252,209,97,14,15,149,122,120,
190,130,77,205,255,153,37,245,49,191,19,127,41,7,32,82,
11,188,64,96,203,88,62,95,4,203,160,224,212,171,28,109,
22,41,219,179,18,38,15,167,1,151,51,98,0,119,7,36,
43,93,243,69,224,87,27,72,85,21,31,74,216,126,200,15,
242,92,48,104,214,159,244,143,227,172,199,11,124,210,180,59,
110,78,91,9,241,103,247,189,166,147,150,234,99,87,56,183,
10,112,118,158,3,236,155,63,182,123,154,29,1,220,165,53,
70,80,177,2,157,142,63,188,52,47,32,21,77,73,61,99,
11,239,170,109,32,181,195,84,193,162,71,163,107,215,56,248,
175,35,246,203,185,50,180,187,107,72,253,117,50,105,128,94,
164,199,12,182,223,114,132,115,15,157,178,18,48,251,30,141,
123,186,115,25,60,55,171,16,250,140,85,136,20,2,95,134,
41,241,25,182,65,244,86,145,38,89,79,112,89,192,190,28,
235,229,93,78,122,58,24,22,17,26,114,167,48,207,125,70,
200,160,13,14,102,75,27,168,47,57,198,183,14,61,164,215,
93,96,139,242,160,195,237,12,252,103,34,121,129,72,245,222,
169,57,138,233,83,230,5,218,24,134,236,96,75,21,106,73,
173,124,201,212,44,92,95,96,161,115,112,117,144,40,33,159,
130,229,179,147,206,153,152,150,189,141,210,76,120,101,198,139,
224,113,111,240,221,66,232,137,91,217,42,242,34,111,191,125,
209,42,202,242,247,155,54,5,81,109,51,216,16,227,17,148,
71,65,102,170,74,52,139,185,97,201,122,45,68,97,204,84,
35,121,16,116,230,152,168,174,146,104,148,5,210,131,98,157,
113,85,19,246,254,87,81,29,244,33,33,219,67,210,196,79,
31,58,194,173,138,211,86,164,91,117,4,248,226,110,244,19,
7,81,139,220,82,119,111,46,56,104,208,5,66,249,131,64,
11,142,79,133,133,98,29,53,187,177,217,231,90,65,47,186,
151,43,129,235,20,214,212,225,10,175,231,18,106,196,207,13,
130,168,243,184,76,2,12,66,0,100,69,161,158,240,130,142,
248,193,48,115,67,57,74,141,198,99,140,237,8,153,178,0,
228,108,87,220,217,168,194,176,7,238,209,202,230,89,83,220,
246,163,185,60,154,18,136,105,171,107,6,50,149,159,201,129,
214,19,174,144,54,234,76,204,164,107,221,233,121,237,255,208,
133,234,88,32,187,138,213,143,161,49,140,145,151,159,1,25,
211,63,148,208,251,166,8,104,132,26,180,221,199,14,189,67,
17,120,10,8,216,17,146,239,132,39,175,39,114,179,202,46,
46,254,229,251,158,125,37,86,249,200,71,230,88,185,231,23,
6,177,169,26,155,161,136,135,54,193,2,202,123,163,28,123,
142,116,84,176,41,119,162,145,255,58,60,35,21,156,170,33,
24,215,81,80,128,36,246,222,236,119,215,167,122,238,93,77,
207,29,250,69,60,219,192,151,36,70,232,253,103,146,68,194,
61,236,55,39,228,245,243,204,170,59,163,28,64,149,82,238,
184,190,3,241,254,143,34,67,43,211,55,166,127,189,101,40,
184,100,250,128,225,212,162,136,63,183,232,62,173,196,205,113,
131,30,216,156,129,226,144,181,106,72,232,120,30,51,205,180,
150,222,9,23,22,73,253,73,207,186,213,172,194,45,109,147,
121,65,166,188,235,241,53,152,213,27,44,229,88,102,169,97,
91,125,145,160,150,201,128,83,183,117,92,126,58,105,206,133,
1,100,37,191,135,233,223,49,80,154,213,162,247,106,124,6,
223,199,198,59,64,224,177,254,141,178,118,12,8,225,188,211,
248,49,138,228,90,101,195,197,52,192,196,102,9,255,22,75,
178,239,205,42,75,191,249,181,206,218,197,62,111,171,84,155,
222,80,167,61,77,127,137,240,92,179,94,53,85,42,165,13,
127,132,140,40,83,16,20,89,40,204,169,214,227,239,195,143,
173,116,223,206,110,158,90,234,174,76,25,221,31,231,3,99};

Uint16 rnd_seed=0;


Uint32 fastrange(Sint32 argx,Sint32 argy)
{
Sint32 rs0,rs1;
rs0=argx;
rs1=argy;
if (rs0<0) rs0= - rs0;      
if (rs1<0) rs1= - rs1;      
if (rs0>rs1) return rs0; else return rs1;       
}


Sint32 calcturn(Sint32 angle0,Sint32 angle1)
{
Sint32 de=(angle1-angle0);
if (de>2048) de=-4096+de;
else
if (de<-2048) de=4096+de;
       
return de;       
}
Sint32 zabs(Sint32 val)
{
if (val>=0) return val; else return -val;       
}


Sint16 SuperAngle(Sint32 value)
{
Sint16 val=value;
while (val<0) val+=4096;

while (val>=4096) val-=4096;
return val;
}

Uint8 random2(void)
{
Uint8 ret=table_rnd[rnd_seed] & 1;
rnd_seed=rnd_seed+1;
rnd_seed=rnd_seed & 1023;
return ret;     
}
Uint8 random4(void)
{
Uint8 ret=table_rnd[rnd_seed] & 3;
rnd_seed=rnd_seed+1;
rnd_seed=rnd_seed & 1023;
return ret;     
}
Uint8 random8(void)
{
Uint8 ret=table_rnd[rnd_seed] & 7;
rnd_seed=rnd_seed+1;
rnd_seed=rnd_seed & 1023;
return ret;     
}
Uint8 random16(void)
{
Uint8 ret=table_rnd[rnd_seed] & 15;
rnd_seed=rnd_seed+1;
rnd_seed=rnd_seed & 1023;
return ret;     
}
Uint8 random32(void)
{
Uint8 ret=table_rnd[rnd_seed] & 31;
rnd_seed=rnd_seed+1;
rnd_seed=rnd_seed & 1023;
return ret;     
}
Uint8 random64(void)
{
Uint8 ret=table_rnd[rnd_seed] & 63;
rnd_seed=rnd_seed+1;
rnd_seed=rnd_seed & 1023;
return ret;     
}Uint8 random128(void)
{
Uint8 ret=table_rnd[rnd_seed] & 127;
rnd_seed=rnd_seed+1;
rnd_seed=rnd_seed & 1023;
return ret;     
}
Uint8 random256(void)
{
Uint8 ret=table_rnd[rnd_seed];
rnd_seed=rnd_seed+1;
rnd_seed=rnd_seed & 1023;
return ret;     
}

Sint32 zsign(Sint32 value)
{
if (value>0) return 1;
else      
if (value<0) return -1;
else return 0;
}


Sint32 it_sin[1024]={0,101,201,302,403,503,604,704,805,906,1006,1107,1207,1308,1409,1509,1610,1710,1811,1912,2012,2113,2213,2314,2415,2515,2616,2716,2817,2917,3018,3118,
3219,3319,3420,3520,3621,3721,3822,3922,4023,4123,4223,4324,4424,4525,4625,4725,4826,4926,5026,5127,5227,5327,5428,5528,5628,5728,5829,5929,6029,6129,6229,6330,
6430,6530,6630,6730,6830,6930,7030,7130,7230,7330,7430,7530,7630,7730,7830,7930,8030,8130,8230,8330,8429,8529,8629,8729,8828,8928,9028,9127,9227,9327,9426,9526,
9625,9725,9824,9924,10023,10123,10222,10321,10421,10520,10620,10719,10818,10917,11016,11116,11215,11314,11413,11512,11611,11710,11809,11908,12007,12106,12205,12304,12403,12501,12600,12699,
12798,12896,12995,13094,13192,13291,13389,13488,13586,13685,13783,13881,13980,14078,14176,14274,14373,14471,14569,14667,14765,14863,14961,15059,15157,15255,15353,15450,15548,15646,15744,15841,
15939,16037,16134,16232,16329,16427,16524,16621,16719,16816,16913,17010,17107,17205,17302,17399,17496,17593,17690,17786,17883,17980,18077,18173,18270,18367,18463,18560,18656,18753,18849,18946,
19042,19138,19234,19331,19427,19523,19619,19715,19811,19907,20002,20098,20194,20290,20385,20481,20577,20672,20768,20863,20958,21054,21149,21244,21339,21434,21529,21624,21719,21814,21909,22004,
22099,22194,22288,22383,22477,22572,22666,22761,22855,22949,23043,23138,23232,23326,23420,23514,23608,23702,23795,23889,23983,24076,24170,24263,24357,24450,24544,24637,24730,24823,24916,25009,
25102,25195,25288,25381,25474,25566,25659,25752,25844,25937,26029,26121,26214,26306,26398,26490,26582,26674,26766,26858,26949,27041,27133,27224,27316,27407,27499,27590,27681,27772,27863,27954,
28045,28136,28227,28318,28409,28499,28590,28680,28771,28861,28952,29042,29132,29222,29312,29402,29492,29582,29672,29761,29851,29940,30030,30119,30209,30298,30387,30476,30565,30654,30743,30832,
30921,31009,31098,31187,31275,31363,31452,31540,31628,31716,31804,31892,31980,32068,32156,32243,32331,32418,32506,32593,32680,32768,32855,32942,33029,33115,33202,33289,33376,33462,33549,33635,
33721,33808,33894,33980,34066,34152,34238,34323,34409,34495,34580,34666,34751,34836,34921,35007,35092,35177,35261,35346,35431,35516,35600,35684,35769,35853,35937,36021,36105,36189,36273,36357,
36441,36524,36608,36691,36775,36858,36941,37024,37107,37190,37273,37355,37438,37521,37603,37685,37768,37850,37932,38014,38096,38178,38260,38341,38423,38504,38586,38667,38748,38829,38910,38991,
39072,39153,39233,39314,39394,39475,39555,39635,39715,39795,39875,39955,40035,40114,40194,40273,40353,40432,40511,40590,40669,40748,40827,40905,40984,41062,41141,41219,41297,41375,41453,41531,
41609,41687,41764,41842,41919,41996,42074,42151,42228,42305,42381,42458,42535,42611,42688,42764,42840,42916,42992,43068,43144,43220,43295,43371,43446,43521,43597,43672,43747,43822,43896,43971,
44046,44120,44194,44269,44343,44417,44491,44565,44638,44712,44785,44859,44932,45005,45078,45151,45224,45297,45370,45442,45515,45587,45659,45731,45804,45875,45947,46019,46091,46162,46233,46305,
46376,46447,46518,46589,46659,46730,46800,46871,46941,47011,47081,47151,47221,47291,47360,47430,47499,47569,47638,47707,47776,47845,47913,47982,48050,48119,48187,48255,48323,48391,48459,48527,
48594,48662,48729,48796,48863,48930,48997,49064,49131,49197,49264,49330,49396,49462,49528,49594,49660,49725,49791,49856,49921,49986,50051,50116,50181,50246,50310,50375,50439,50503,50567,50631,
50695,50759,50822,50886,50949,51012,51076,51139,51201,51264,51327,51389,51452,51514,51576,51638,51700,51762,51823,51885,51946,52008,52069,52130,52191,52252,52312,52373,52433,52494,52554,52614,
52674,52734,52793,52853,52912,52972,53031,53090,53149,53208,53266,53325,53383,53442,53500,53558,53616,53674,53731,53789,53846,53903,53961,54018,54075,54131,54188,54245,54301,54357,54413,54469,
54525,54581,54637,54692,54748,54803,54858,54913,54968,55022,55077,55132,55186,55240,55294,55348,55402,55456,55509,55563,55616,55669,55722,55775,55828,55880,55933,55985,56038,56090,56142,56193,
56245,56297,56348,56400,56451,56502,56553,56603,56654,56705,56755,56805,56855,56905,56955,57005,57054,57104,57153,57202,57251,57300,57349,57398,57446,57495,57543,57591,57639,57687,57734,57782,
57829,57877,57924,57971,58018,58064,58111,58157,58204,58250,58296,58342,58388,58433,58479,58524,58569,58614,58659,58704,58749,58793,58838,58882,58926,58970,59014,59057,59101,59144,59188,59231,
59274,59317,59359,59402,59444,59487,59529,59571,59613,59654,59696,59738,59779,59820,59861,59902,59943,59983,60024,60064,60104,60144,60184,60224,60264,60303,60342,60381,60421,60459,60498,60537,
60575,60614,60652,60690,60728,60766,60803,60841,60878,60915,60952,60989,61026,61062,61099,61135,61171,61207,61243,61279,61315,61350,61385,61421,61456,61490,61525,61560,61594,61629,61663,61697,
61731,61764,61798,61831,61865,61898,61931,61963,61996,62029,62061,62093,62125,62157,62189,62221,62252,62284,62315,62346,62377,62408,62438,62469,62499,62530,62560,62589,62619,62649,62678,62708,
62737,62766,62795,62823,62852,62880,62909,62937,62965,62993,63020,63048,63075,63102,63130,63156,63183,63210,63236,63263,63289,63315,63341,63367,63392,63418,63443,63468,63493,63518,63543,63567,
63592,63616,63640,63664,63688,63711,63735,63758,63781,63804,63827,63850,63873,63895,63917,63940,63962,63983,64005,64027,64048,64069,64090,64111,64132,64153,64173,64193,64214,64234,64254,64273,
64293,64312,64332,64351,64370,64388,64407,64426,64444,64462,64480,64498,64516,64534,64551,64568,64585,64602,64619,64636,64652,64669,64685,64701,64717,64733,64748,64764,64779,64794,64809,64824,
64839,64854,64868,64882,64896,64910,64924,64938,64951,64964,64978,64991,65004,65016,65029,65041,65053,65066,65077,65089,65101,65112,65124,65135,65146,65157,65168,65178,65189,65199,65209,65219,
65229,65238,65248,65257,65266,65275,65284,65293,65301,65310,65318,65326,65334,65342,65350,65357,65364,65372,65379,65385,65392,65399,65405,65411,65418,65423,65429,65435,65440,65446,65451,65456,
65461,65465,65470,65474,65479,65483,65487,65491,65494,65498,65501,65504,65507,65510,65513,65515,65518,65520,65522,65524,65526,65527,65529,65530,65531,65532,65533,65534,65534,65535,65535,65535};

void InitMath(void)
{
Sint32 i;

for (i=0;i<1024;i++)
f_sin[     i]= it_sin[i];

for (i=0;i<1024;i++)
f_sin[1024+i]= it_sin[1023-i];

for (i=0;i<1024;i++)
f_sin[2048+i]=-it_sin[i];

for (i=0;i<1024;i++)
f_sin[3072+i]=-it_sin[1023-i];

for (i=0;i<4096;i++)
f_cos[i]=f_sin[(i+1024)%4096];
/*
 for (i=0;i<=1023;i++)
 f_tan[i]=FPDIV(f_sin[i],f_cos[i]);
 f_tan[1023]=0xFFFFFFF;     
*/
}
