#include "math.h"

#include "zmath.h"
#include "stdlib.h"
#include "globalvar.h"
#define FPDIV(x,y)	((((x)<<12)/((y)))>>4)

zzUint16 arctan(zzSint32 argx,zzSint32 argy)
{
zzSint16 val;
zzUint16 d,res;
if (argx==0)
 {
  res=1024;
 }
 else
 {
 d=1024;res=512;
 val=FPDIV(argy,argx);
 if (val<0) val=-val;
 while (d>1)
  {
   d=d>>1;
  if (f_tan[res]>val) res=res-d;
  else
  if (f_tan[res]<val) res=res+d;
  else d=0;
  }

 }
if ((argx<=0)&(argy>0)) res=2048-res;
else
if ((argx<=0)&(argy<0)) res=2048+res;
else
if ((argx>=0)&(argy<0)) res=4096-res;

return res;
}

zzUint32 fastrange(zzSint32 argx,zzSint32 argy)
{
zzSint32 rs0,rs1;
rs0=argx;
rs1=argy;
if (rs0<0) rs0= - rs0;
if (rs1<0) rs1= - rs1;
if (rs0>rs1) return rs0; else return rs1;
}


zzUint32 srange(zzSint32 argx,zzSint32 argy)
{
zzUint32 res;
float t0,t1,val;
t0=argx/65536;
t0=t0*t0;
t1=argy/65536;
t1=t1*t1;

val=sqrt(t0+t1);
val=val*65535;
res=val;
return (val);
}

zzUint16 rndseed,lrndseed;

zzUint16 rnd(void)
{
rndseed=rand();
return rndseed;
}

zzUint16 zzrandom(zzUint16 value)
{

return (rnd()%value);
}
zzSint32 calcturn(zzSint32 angle0,zzSint32 angle1)
{
zzSint32 de=(angle1-angle0);
if (de>2048) de=-4096+de;
else
if (de<-2048) de=4096+de;

return de;
}
zzSint32 zabs(zzSint32 val)
{
if (val>=0) return val; else return -val;
}


zzSint16 SuperAngle(zzSint32 value)
{
zzSint16 val=value;
while (val<0) val+=4096;

while (val>=4096) val-=4096;
return val;
}

zzSint32 FloorProbe(zzSint32 x,zzSint32 y,zzSint32 z)
{
zzUint8 cx=x>>16;
zzUint8 cy=y>>16;
zzUint8 cz=z>>16;
zzSint32 t=cx+cy*128+cz*16384;
zzSint32 ix=x-cx*65536;
zzSint32 iy=y-cy*65536;
zzSint32 rz,a,b;
a=meshz[t]+((meshz[t+1])-meshz[t])*ix/65536;
b=meshz[t+128]+((meshz[t+129])-meshz[t+128])*ix/65536;

rz=a+(b-a)*iy/65536;
return rz;
//add some level-end detection;
}
