#include "controlpad.h"

#define AXIS_DEADZONE 7000

static const zzSint8 angle_detection[9]=
{7, 0, 1,
 6,-1, 2,
 5, 4, 3};
int i_keyb[23];
#ifdef PANDORA
static const SDLKey sd_keyb[23]={SDLK_KP8,SDLK_KP9,SDLK_KP6,SDLK_KP3,SDLK_KP2,SDLK_KP1,SDLK_KP4,SDLK_KP7,
SDLK_HOME,SDLK_PAGEDOWN,SDLK_END,SDLK_PAGEUP,SDLK_RSHIFT,SDLK_RCTRL,SDLK_MINUS,SDLK_EQUALS,SDLK_TAB,SDLK_RETURN,SDLK_z,SDLK_UP,SDLK_RIGHT,SDLK_DOWN,SDLK_LEFT
};
#else
static const SDLKey sd_keyb[23]={SDLK_KP8,SDLK_KP9,SDLK_KP6,SDLK_KP3,SDLK_KP2,SDLK_KP1,SDLK_KP4,SDLK_KP7,
SDLK_q,SDLK_w,SDLK_e,SDLK_r,SDLK_1,SDLK_2,SDLK_MINUS,SDLK_EQUALS,SDLK_TAB,SDLK_RETURN,SDLK_z,SDLK_UP,SDLK_RIGHT,SDLK_DOWN,SDLK_LEFT
};
#endif

static const int sd_key_ref[11]=
{
PAD_A,PAD_B,PAD_X,PAD_Y,PAD_L1,PAD_R1,PAD_L2,PAD_R2,PAD_SELECT,PAD_START,PAD_Z

};
void ControlPadUpdate(void)
{

 SDL_JoystickUpdate();
 /*
 controlpadbutton[PAD_A]=SDL_JoystickGetButton(joy,VK_FA);
 controlpadbutton[PAD_X]=SDL_JoystickGetButton(joy,VK_FX);
 controlpadbutton[PAD_B]=SDL_JoystickGetButton(joy,VK_FB);
 controlpadbutton[PAD_Y]=SDL_JoystickGetButton(joy,VK_FY);
 controlpadbutton[PAD_Z]=SDL_JoystickGetButton(joy,VK_FZ);

 controlpadbutton[PAD_L1]=SDL_JoystickGetButton(joy,VK_FL);
 controlpadbutton[PAD_R1]=SDL_JoystickGetButton(joy,VK_FR);
 controlpadbutton[PAD_L2]=SDL_JoystickGetButton(joy,VK_VOL_DOWN);
 controlpadbutton[PAD_R2]=SDL_JoystickGetButton(joy,VK_VOL_UP);

 controlpadbutton[PAD_START]=SDL_JoystickGetButton(joy,VK_START);
 controlpadbutton[PAD_SELECT]=SDL_JoystickGetButton(joy,VK_SELECT);
*/
 controlpadbutton[PAD_A]=SDL_JoystickGetButton(joy,0);
 controlpadbutton[PAD_X]=SDL_JoystickGetButton(joy,1);
 controlpadbutton[PAD_B]=SDL_JoystickGetButton(joy,2);
 controlpadbutton[PAD_Y]=SDL_JoystickGetButton(joy,3);
 controlpadbutton[PAD_Z]=SDL_JoystickGetButton(joy,10);

 controlpadbutton[PAD_L1]=SDL_JoystickGetButton(joy,4);
 controlpadbutton[PAD_R1]=SDL_JoystickGetButton(joy,5);
 //controlpadbutton[PAD_L2]=SDL_JoystickGetButton(joy,VK_VOL_DOWN);
 //controlpadbutton[PAD_R2]=SDL_JoystickGetButton(joy,VK_VOL_UP);

 controlpadbutton[PAD_START]=SDL_JoystickGetButton(joy,6);
 controlpadbutton[PAD_SELECT]=SDL_JoystickGetButton(joy,8);


controlpadangle=-1;
zzSint16 axis=SDL_JoystickGetAxis(joy,0);
zzUint8 x=1;
if (axis<-AXIS_DEADZONE) x=0;
else
if (axis>AXIS_DEADZONE) x=2;
axis=SDL_JoystickGetAxis(joy,1);
zzUint8 y=1;
if (axis<-AXIS_DEADZONE) y=0;
else
if (axis>AXIS_DEADZONE) y=2;

 controlpadangle=angle_detection[x+y*3];
//#ifdef WIN32
//Keyboard
		SDL_Event event;
int i;
		while (SDL_PollEvent (&event))
		{
			switch (event.type)
			{
				case SDL_QUIT:
                     GameLoopEnabled=0;
                     break;
                case SDL_KEYDOWN:
                     for (i=0;i<23;i++)
					 if (event.key.keysym.sym==sd_keyb[i])
                     i_keyb[i]=1;
if (event.key.keysym.sym==SDLK_ESCAPE)
GameLoopEnabled=0;
					break;
                case SDL_KEYUP:
                     for (i=0;i<23;i++)
					 if (event.key.keysym.sym==sd_keyb[i])
                     i_keyb[i]=0;
					break;

            }
        }

for (i=0;i<8;i++)
 if (i_keyb[i]) controlpadangle=i;

if (i_keyb[19] | i_keyb[20] | i_keyb[21] | i_keyb[22])
{
if (i_keyb[19]) controlpadangle=0;
else
if (i_keyb[20]) controlpadangle=2;
else
if (i_keyb[21]) controlpadangle=4;
else
if (i_keyb[22]) controlpadangle=6;
else
if (i_keyb[19] & i_keyb[20]) controlpadangle=1; else
if (i_keyb[20] & i_keyb[21]) controlpadangle=3; else
if (i_keyb[21] & i_keyb[22]) controlpadangle=5; else
if (i_keyb[22] & i_keyb[19]) controlpadangle=7;


}


for (i=8;i<19;i++)
 if (i_keyb[i]) controlpadbutton[i-8]=1;


//#endif
#ifdef GP2X
/*
if (SDL_JoystickGetButton(joy,VK_UP)) controlpadangle=0;
else
if (SDL_JoystickGetButton(joy,VK_UP_RIGHT)) controlpadangle=1;
else
if (SDL_JoystickGetButton(joy,VK_RIGHT)) controlpadangle=2;
else
if (SDL_JoystickGetButton(joy,VK_DOWN_RIGHT)) controlpadangle=3;
else
if (SDL_JoystickGetButton(joy,VK_DOWN)) controlpadangle=4;
else
if (SDL_JoystickGetButton(joy,VK_DOWN_LEFT)) controlpadangle=5;
else
if (SDL_JoystickGetButton(joy,VK_LEFT)) controlpadangle=6;
else
if (SDL_JoystickGetButton(joy,VK_UP_LEFT)) controlpadangle=7;

//Dpad
if ((SDL_JoystickGetButton(joy,VK_UP))&(SDL_JoystickGetButton(joy,VK_RIGHT))) controlpadangle=1;
else
if ((SDL_JoystickGetButton(joy,VK_DOWN))&(SDL_JoystickGetButton(joy,VK_RIGHT))) controlpadangle=3;
else
if ((SDL_JoystickGetButton(joy,VK_DOWN))&(SDL_JoystickGetButton(joy,VK_LEFT))) controlpadangle=5;
else
if ((SDL_JoystickGetButton(joy,VK_UP))&(SDL_JoystickGetButton(joy,VK_LEFT))) controlpadangle=7;

if (CradleMode)
{
zzSint16 axis=SDL_JoystickGetAxis(USBjoy,0);
zzUint8 x=1;
if (axis<-AXIS_DEADZONE) x=0;
else
if (axis>AXIS_DEADZONE) x=2;
axis=SDL_JoystickGetAxis(USBjoy,1);
zzUint8 y=1;
if (axis<-AXIS_DEADZONE) y=0;
else
if (axis>AXIS_DEADZONE) y=2;

 controlpadangle=angle_detection[x+y*3];


 controlpadbutton[PAD_A]=SDL_JoystickGetButton(USBjoy,USBVK_FA);
 controlpadbutton[PAD_X]=SDL_JoystickGetButton(USBjoy,USBVK_FX);
 controlpadbutton[PAD_B]=SDL_JoystickGetButton(USBjoy,USBVK_FB);
 controlpadbutton[PAD_Y]=SDL_JoystickGetButton(USBjoy,USBVK_FY);


 controlpadbutton[PAD_L1]=SDL_JoystickGetButton(USBjoy,USBVK_VOL_DOWN);
 controlpadbutton[PAD_R1]=SDL_JoystickGetButton(USBjoy,USBVK_VOL_UP);
 controlpadbutton[PAD_Z]=0;
 if (controlpadbutton[PAD_L1]) if (controlpadbutton[PAD_R1])  controlpadbutton[PAD_Z]=1;

 controlpadbutton[PAD_START]=SDL_JoystickGetButton(USBjoy,USBVK_START);
 controlpadbutton[PAD_SELECT]=SDL_JoystickGetButton(USBjoy,USBVK_SELECT);


}
*/
#endif
}
