#include <SDL/SDL_mixer.h>
#include <string.h>
#include <SDL.h>

#include "vars.h"
#include "ssystem.h"
#include "palette.h"

#ifdef GP2X
#include "sys/mman.h"
#include "fcntl.h"

volatile unsigned short *MEM_REG;
unsigned long   gp2x_dev=0;
void RamHack(void)//I't me! RamHack!
{
}
#endif

void Terminate(void)
{
    Mix_CloseAudio();
    SDL_Quit();
#ifdef GP2X
    chdir("/usr/gp2x");
    execl("/usr/gp2x/gp2xmenu", "/usr/gp2x/gp2xmenu", NULL);
#endif
}

SDL_Surface *screen = NULL;
SDL_Joystick *joy = NULL;


Uint8 d_sound_count = 0;
int audio_channels = 2;
int audio_rate = 22050;

Uint16 audio_format = AUDIO_S16;
int audio_buffers = 1024;

void InitGameCore(void)
{
    atexit (Terminate);

#ifdef GP2X
    RamHack();
#endif

    if (SDL_Init (SDL_INIT_VIDEO | SDL_INIT_AUDIO | SDL_INIT_JOYSTICK) < 0) {
        fprintf (stderr, "Couldn't initialize SDL: %s\n", SDL_GetError ());
        exit (1);
    }
    if(Mix_OpenAudio(audio_rate, audio_format, audio_channels, audio_buffers)) {
        printf("Unable to open audio!\n");
        exit(1);
    }
    Mix_QuerySpec(&audio_rate, &audio_format, &audio_channels);

#if defined(GP2X) || defined(CAANOO) 
    SDL_ShowCursor(SDL_DISABLE);
    screen = SDL_SetVideoMode (320, 240, 8, SDL_HWSURFACE || SDL_DOUBLEBUF);
#elif defined(PANDORA)
    SDL_ShowCursor(SDL_DISABLE);
    screen = SDL_SetVideoMode (800, 480, 32, SDL_HWSURFACE| SDL_DOUBLEBUF | SDL_FULLSCREEN);
#else
//screen = SDL_SetVideoMode (320 ,240, 32, SDL_SWSURFACE);
    screen = SDL_SetVideoMode (640 ,480, 32, SDL_HWSURFACE);
#endif
    InitPalette();
#ifdef GP2X
    Uint8 i;
    for (i=0; i<32; i++)
    {
        screen->format->palette->colors[i].r=palette[i][0];
        screen->format->palette->colors[i].g=palette[i][1];
        screen->format->palette->colors[i].b=palette[i][2];
    }
    SDL_SetColors(screen,screen->format->palette->colors,0,256);
#endif


    /* Check and open joystick device */
    if (SDL_NumJoysticks() > 0) {
        joy = SDL_JoystickOpen(0);
        if(!joy) {
            fprintf (stderr, "Couldn't open joystick 0: %s\n", SDL_GetError ());
        }
    }
    LoadSound();
    SetVolume(127);

}

#define AXIS_DEADZONE 7000
static const Sint8 angle_detection[9]=
{   7, 0, 1,
    6,-1, 2,
    5, 4, 3
};
int i_keyb[23];

#if !defined(PANDORA)
static const SDLKey sd_keyb[23]= {SDLK_KP8,SDLK_KP9,SDLK_KP6,SDLK_KP3,SDLK_KP2,SDLK_KP1,SDLK_KP4,SDLK_KP7,
                                  SDLK_SPACE,SDLK_LCTRL,SDLK_z,SDLK_LSHIFT,SDLK_RETURN,SDLK_RCTRL,SDLK_MINUS,SDLK_EQUALS,SDLK_TAB,SDLK_ESCAPE,SDLK_z,SDLK_UP,SDLK_RIGHT,SDLK_DOWN,SDLK_LEFT
                                 };
#else
static const SDLKey sd_keyb[23]= {SDLK_KP8,SDLK_KP9,SDLK_KP6,SDLK_KP3,SDLK_KP2,SDLK_KP1,SDLK_KP4,SDLK_KP7,
                                  SDLK_HOME,SDLK_PAGEDOWN,SDLK_END,SDLK_p,SDLK_PAGEUP,SDLK_o,SDLK_s,SDLK_d,SDLK_LALT,SDLK_LCTRL,SDLK_l,SDLK_UP,SDLK_RIGHT,SDLK_DOWN,SDLK_LEFT
                                 };
#endif

static const int sd_key_ref[11]=
{
    0,1,2,3,4,5,6,7,8,9,10
};

#ifdef GP2X// GP2X button mapping
/*


enum
{
     BTN_A = 0,     //       A /             1
     BTN_X = 1,     //       X /             2
     BTN_B = 2,     //       B /             3
     BTN_Y = 3,     //       Y /             4
     BTN_L = 4,     //       L /         5, L1
     BTN_R = 5,     //       R /         6, L2
     BTN_HOME = 6,  //    Home /         7, R1
     BTN_HOLD = 7,  //    Hold /         8, R2
     BTN_HELP1 = 8, //  Help I /        Select
     BTN_HELP2 = 9, // Help II /         Start
};


*/
enum MAP_KEY
{
    VK_FA         , // 1
    VK_FX         , // 2
    VK_FB         , // 3
    VK_FY         , // 4
    VK_FL         , // 5
    VK_FR         , // 6
    VK_HOME       , // 7
    VK_START      , // 8
    VK_SELECT     , // 9
    VK_SELECT2    , // 10
};
#else
enum MAP_KEY
{
    VK_FA         , // 0
    VK_FX         , // 1
    VK_FB         , // 2
    VK_FY         , // 3
    VK_VOL_DOWN   , // 4
    VK_VOL_UP     , // 5
    VK_FL         , // 6
    VK_FR         , // 7
    VK_SELECT     , // 8
    VK_START      , // 9
    VK_FZ          // 10
};
#endif

Sint8 olddpad=-1;
void CoreProcInput(void)
{
    int i;

    SDL_JoystickUpdate();
    button[0]=SDL_JoystickGetButton(joy,VK_FA);
    button[1]=SDL_JoystickGetButton(joy,VK_FX);
    button[2]=SDL_JoystickGetButton(joy,VK_FB);
    button[3]=SDL_JoystickGetButton(joy,VK_FY);
    button[4]=SDL_JoystickGetButton(joy,VK_FL);
    button[5]=SDL_JoystickGetButton(joy,VK_FR);
// button[6]=SDL_JoystickGetButton(joy,VK_VOL_DOWN);
// button[7]=SDL_JoystickGetButton(joy,VK_VOL_UP);
//    button[8]=SDL_JoystickGetButton(joy,VK_HOME);
// button[9]=SDL_JoystickGetButton(joy,VK_SELECT);

    dpad=-1;
    Sint16 axis=SDL_JoystickGetAxis(joy,0);
    Uint8 x=1;
    if (axis<-AXIS_DEADZONE) x=0;
    else if (axis>AXIS_DEADZONE) x=2;
    axis=SDL_JoystickGetAxis(joy,1);
    Uint8 y=1;
    if (axis<-AXIS_DEADZONE) y=0;
    else if (axis>AXIS_DEADZONE) y=2;

    dpad=angle_detection[x+y*3];
#if !defined(GP2X) && !defined(CAANOO)
//Keyboard
    SDL_Event event;

    while (SDL_PollEvent (&event))
    {
        switch (event.type)
        {
        case SDL_QUIT:
            GameLoopEnabled=0;
            break;
        case SDL_KEYDOWN:
            for (i=0; i<23; i++)
                if (event.key.keysym.sym==sd_keyb[i])
                    i_keyb[i]=1;
            break;
        case SDL_KEYUP:
            for (i=0; i<23; i++)
                if (event.key.keysym.sym==sd_keyb[i])
                    i_keyb[i]=0;
            break;

        }
    }
    for (i=0; i<8; i++)
        if (i_keyb[i]) dpad=i;

    if ((i_keyb[0]) & (i_keyb[2])) dpad=1;
    if ((i_keyb[2]) & (i_keyb[4])) dpad=3;
    if ((i_keyb[4]) & (i_keyb[6])) dpad=5;
    if ((i_keyb[6]) & (i_keyb[0])) dpad=7;
    if (i_keyb[19] | i_keyb[20] | i_keyb[21] | i_keyb[22])
    {
        if ((i_keyb[19])&(i_keyb[21]==0)&(i_keyb[20]==0)&(i_keyb[22]==0)) dpad=0;
        else if ((i_keyb[20])&(i_keyb[21]==0)&(i_keyb[22]==0)&(i_keyb[19]==0)) dpad=2;
        else if ((i_keyb[21])&(i_keyb[22]==0)&(i_keyb[20]==0)&(i_keyb[19]==0)) dpad=4;
        else if ((i_keyb[22])&(i_keyb[21]==0)&(i_keyb[20]==0)&(i_keyb[19]==0)) dpad=6;
        else if (i_keyb[19] & i_keyb[20]) dpad=1;
        else if (i_keyb[20] & i_keyb[21]) dpad=3;
        else if (i_keyb[21] & i_keyb[22]) dpad=5;
        else if (i_keyb[22] & i_keyb[19]) dpad=7;


    }



    for (i=8; i<19; i++)
        if (i_keyb[i]) button[i-8]=1;

    if (button[8] == 1)
	    GameLoopEnabled=0;
#endif
//volume control
    if (volumedelay) volumedelay--;
    if (button[7])
    {
        if (volume+volumepower<127) SetVolume(volume+volumepower);
        else SetVolume(127);
        volumedelay=20;
    }
    else if (button[6])
    {
        if (volume-volumepower>0) SetVolume(volume-volumepower);
        else SetVolume(0);
        volumedelay=20;
    }
//no more volume control
    dpadi=0;
    if (olddpad!=dpad)
    {
        if (dpad>=0) dpadi=1;
    }
    else
        dpadi=2;


    olddpad=dpad;

    buttonpressed=0;
    for (i=0; i<12; i++)
        if ((i!=6)&(i!=7))// ignore volume buttons
        {
            if (button[i]==0) vbutton[i]=0;
            else if (vbutton[i]<2) vbutton[i]++;
            if (vbutton[i]>buttonpressed) buttonpressed=vbutton[i];
        }

}

#if defined(PANDORA)
U32 scrbuf2[800*480*4/4];
#elif !defined(GP2X) && !defined(CAANOO)
U32 scrbuf2[1228800/4];
#endif

void GameCoreTick(void)
{
    CoreProcInput();

    SDL_LockSurface(screen);

#if defined(GP2X) || defined(CAANOO)
    memcpy(screen->pixels,scrbuf,76800);
#elif defined(PANDORA)
    U32 x,y,i,ii,col;
    U8 c,r,b,g;
    i=0;
    ii=0;
    
    for (y=0; y<240; y++)
    {
        for (x=0; x<320; x++)
        {
            c=scrbuf[i++];
            r=palette[c][2];
            g=palette[c][1];
            b=palette[c][0];
            col=b<<16;
            col+=+g<<8;
            col+=r;
            scrbuf2[ii]=col;
            scrbuf2[ii+1]=col;
            scrbuf2[ii+800]=col;
            scrbuf2[ii+801]=col;

            if (x&1==1) {
	       ii+=2;
            } else {
	       scrbuf2[ii+2]=col;
	       scrbuf2[ii+802]=col;
	       ii+=3;
	    }
        }
        ii+=800;
    }
    memcpy(screen->pixels,scrbuf2,800*480*4);
#else
    U32 x,y,i,ii,col;
    U8 c,r,b,g;
    i=0;
    ii=0;
    /*
    for (y=0;y<240;y++)
    {
    for (x=0;x<320;x++)
    {
    c=scrbuf[i++];
    r=palette[c][2];
    g=palette[c][1];
    b=palette[c][0];
    col=b<<16;
    col+=+g<<8;
    col+=r;
    scrbuf2[ii]=col;
    ii++;
    }
    }
    memcpy(screen->pixels,scrbuf2,76800*4);
    */
    for (y=0; y<240; y++)
    {
        for (x=0; x<320; x++)
        {
            c=scrbuf[i++];
            r=palette[c][2];
            g=palette[c][1];
            b=palette[c][0];
            col=b<<16;
            col+=+g<<8;
            col+=r;
            scrbuf2[ii]=col;
            scrbuf2[ii+1]=col;
            scrbuf2[ii+640]=col;
            scrbuf2[ii+641]=col;

            ii+=2;
        }
        ii+=640;
    }
    memcpy(screen->pixels,scrbuf2,1228800);



#endif

    SDL_UnlockSurface(screen);

    SDL_Flip(screen);

#ifdef GP2X
    SDL_Delay(30);
#else
    SDL_Delay(40);
#endif
    voiceon=0;
    if (Mix_Playing(0)) voiceon=1;
}
void ShutDownCore(void)
{


}


// SOUND SYSTEM
char spath[128];
Mix_Music *music = NULL;
Mix_Chunk *d_sound[8];
Mix_Chunk *e_sound;

void LoadSound(void)
{
    d_sound[0]=Mix_LoadWAV("data/s0.wav");
    d_sound[1]=Mix_LoadWAV("data/s1.wav");
    d_sound[2]=Mix_LoadWAV("data/s2.wav");
    d_sound[3]=Mix_LoadWAV("data/s3.wav");
    d_sound[4]=Mix_LoadWAV("data/s4.wav");
    d_sound[5]=Mix_LoadWAV("data/s5.wav");
    d_sound[6]=Mix_LoadWAV("data/s6.wav");
    d_sound[7]=Mix_LoadWAV("data/s7.wav");
}

void PlayMusic(unsigned char itrack)
{
    if (itrack==128)
        Mix_PauseMusic();
    else
    {
        sprintf(spath,"data/%i.ogg",itrack);
        music = Mix_LoadMUS(spath);
        Mix_PlayMusic(music, 1);
    }
    MusicPlaying=itrack;
}
void PlaySound(unsigned char ibank,signed char pan)
{
    Mix_SetPanning(0,127,127);
    Mix_PlayChannel(0,d_sound[ibank],0);
}
void PlaySoundEx(unsigned char ibank,signed char pan)
{
    sprintf(spath,"data/e%i.wav",ibank);
    Mix_SetPanning(0,127,127);
    e_sound=Mix_LoadWAV(spath);
    Mix_PlayChannel(0,e_sound,0);
}

void SetVolume(unsigned char ivolume)
{
    volume=ivolume;
    Mix_Volume(0,volume);
//Mix_VolumeMusic(volume);
}
