#include "vars.h"
void ClrScr(void)
{
    Uint32 i;
    for (i=0; i<76800; i++) scrbuf[i]=0;

}
void DrawScreen(unsigned char index)
{
    Uint32 i,ii,x,y;
    i=0;
    ii=index*19200;

    for (y=0; y<120; y++)
    {
        for (x=0; x<160; x++)
        {
            scrbuf[i++]=screens[ii];
            scrbuf[i++]=screens[ii];
            ii++;
        }
        i+=320;
    }

}

void DrawScreenEx(unsigned char index,signed short ix,signed short iy,unsigned char tcolor)
{
    Sint32 i,ii,x,y;
    i=0;

    for (y=0; y<120; y++)
    {
        ii=index*19200+y*160;
        i=ix+(iy+y)*640;

        if ((y+iy>=0)&(y+iy<120))
            for (x=0; x<160; x++)
            {
                if ((x+ix>=0)&(x+ix<320))
                    if (screens[ii]!=tcolor)
                    {
                        scrbuf[i]=screens[ii];
                        scrbuf[i+1]=screens[ii];
                    }
                ii++;
                i+=2;
            }
    }



}

void DrawSprite(unsigned short index,signed short sx,signed short sy)
{
    Sint32 i,ii,ii0,x,y,x0,y0,x1,y1;
    Uint8 c,tc;
    x0=sx;
    y0=sy;
    x1=x0+32;
    y1=y0+16;

    ii0 =((index)/64)*16384;//sprite page
    ii0+=(index % 8)*16;// X
    ii0+=((index / 8) % 8)*16*128;// X

    tc=sprites[ii0];
    if (x0<320)
        if (x1>0)
            if (y0<120)
                if (y1>0)
                {   //draw
                    if (x0<0)x0=0;
                    if (x1>320)x1=320;
                    if (y0<0)y0=0;
                    if (y1>120)y1=120;

                    for (y=y0; y<y1; y++)
                    {
                        i=(x0)+(y)*640;
                        ii=ii0+(x0/2-sx/2)+(y-sy)*128;
                        for (x=x0; x<x1; x+=2)
                        {
                            c=sprites[ii];
                            if (c!=tc)
                            {
                                scrbuf[i]=c;
                                scrbuf[i+1]=c;
                            }
                            i+=2;
                            ii++;
                        }
                    }

                }//draw
}

void DrawFlipSprite(unsigned short index,signed short sx,signed short sy)
{
    Sint32 i,ii,ii0,x,y,x0,y0,x1,y1;
    Uint8 c,tc;
    x0=sx;
    y0=sy;
    x1=x0+32;
    y1=y0+16;

    ii0 =((index)/64)*16384;//sprite page
    ii0+=(index % 8)*16;// X
    ii0+=((index / 8) % 8)*16*128;// X

    tc=sprites[ii0];
    if (x0<320)
        if (x1>0)
            if (y0<120)
                if (y1>0)
                {   //draw
                    if (x0<0)x0=0;
                    if (x1>320)x1=320;
                    if (y0<0)y0=0;
                    if (y1>120)y1=120;

                    for (y=y0; y<y1; y++)
                    {
                        i=(x0)+(y)*640;
                        ii=15+ii0-(x0/2-sx/2)+(y-sy)*128;
                        for (x=x0; x<x1; x+=2)
                        {
                            c=sprites[ii];
                            if (c!=tc)
                            {
                                scrbuf[i]=c;
                                scrbuf[i+1]=c;
                            }
                            i+=2;
                            ii--;
                        }
                    }

                }//draw
}

void DrawSpriteC(unsigned short index,signed short sx,signed short sy,unsigned short col)
{
    Sint32 i,ii,ii0,x,y,x0,y0,x1,y1;
    Uint8 c,tc;
    x0=sx;
    y0=sy;
    x1=x0+16;
    y1=y0+16;

    ii0 =((index)/64)*16384;//sprite page
    ii0+=(index % 8)*16;// X
    ii0+=((index / 8) % 8)*16*128;// X

    tc=sprites[ii0];
    if (x0<320)
        if (x1>0)
            if (y0<120)
                if (y1>0)
                {   //draw
                    if (x0<0)x0=0;
                    if (x1>320)x1=320;
                    if (y0<0)y0=0;
                    if (y1>120)y1=120;

                    for (y=y0; y<y1; y++)
                    {
                        i=(x0)+(y)*640;
                        ii=ii0+(x0-sx)+(y-sy)*128;
                        for (x=x0; x<x1; x++)
                        {
                            c=sprites[ii];
                            if (c!=tc)
                            {
                                scrbuf[i]=col;
                                scrbuf[i+1]=col;
                            }
                            i+=2;
                            ii++;
                        }
                    }

                }//draw
}


void DrawText(signed short sx,signed short sy,unsigned char col,char text[16])
{
    Uint16 i,c;
    Sint32 ii,x,y;
    if (random128()==0) {
        sx+=10;
        sy+=5;
    }
    for (i=0; i<16; i++)
    {
        c=text[i];
        if (c!=32)
        {
            if (random64()==0) c=random64();
            ii =64;//SpritePage

            ii+=((c/8)%2)*64;//SP Switch

            ii+=c % 8;
            ii+=(c/16)*8;

            x=sx+i*18;
            y=sy;

            DrawSpriteC(ii,x,y,col);

        }
    }

}
