#include "vars.h"
#include "sblit.h"
#include "mobs.h"
#include "zmath.h"

char spath[128];

void SpecialScreen(Uint8 index)
{
    screentime=10;
    screenid=index;
    levelspecial=1;

}
Uint8 cutscenestate=0,oldmusic;
Uint16 cutscenecount=0;

Uint8 csscreen[7][6]=
{
    {14,14,14,14,14,14},
    {14,14,14,14,14,14},
    {14,16,16,16,16,16},
    {14,14,14,14,14,14},
    {14,14,14,14,14,14},
    {14,14,14,14,14,14},
    {14,14,14,14,14,14}
};
Uint8 csscreen0[7][6]=
{
    {0,0,0,0,0,0},
    {0,0,11,5,0,0},
    {0,0,0,0,0,0},
    {0,0,0,0,0,0},
    {0,0,0,0,0,0},
    {0,0,0,0,0,0},
    {0,0,0,0,0,0}
};

void PlayCutscene(void)
{
    Uint8 i;
    switch (cutscenestate)
    {
    case 0:
        DrawScreen(7);
        DrawText(10,100,15,"read message    ");
        if (cutscenecount>10)
            if ((buttonpressed)|(cutscenecount>120))
            {
                cutscenecount=0;
                cutscenestate=1;
                PlaySoundEx(20+10*level+cutscene,0);
            }

        break;
    case 1:
        i=csscreen[level][cutscene];
        if (cutscenecount>30)
            if (csscreen0[level][cutscene])
                i=csscreen0[level][cutscene];
        if (i==14)
            DrawScreen(14+count/3 %2);
        else
            DrawScreen(i);

        if (cutscenecount>10)
            if ((buttonpressed)|(cutscenecount>800)|(voiceon==0))
            {
                cutscenecount=0;
                cutscenestate=2;
                PlaySoundEx(7,0);
            }

        break;
    case 2:
        DrawScreen(7);
        DrawText(10,100,15,"end of message  ");
        if (cutscenecount>10)
            if ((buttonpressed)|(cutscenecount>120))
            {
                levelspecial=0;
                cutscene++;
                PlayMusic(oldmusic);
            }
        break;


    }
    cutscenecount++;
}

void ClearMobs(void)
{

    Uint8 i,k;
    for (i=0; i<64; i++)
        for (k=0; k<16; k++)
            mob[i][k]=0;

    for (i=0; i<32; i++)
    {
        item[i][0]=0;
        item[i][3]=0;
        bullet[i][0]=0;
    }
}
Uint8 mobhp[18]=
{   5,5,5,5,
    2,2,
    1,50,
    1,10,
    2,5,
    2,0,
    0,20,
    0,0
};

void OutFitMob(Uint8 i,Uint8 tp)
{
    mob[i][11]=tp*16;
    mob[i][12]=14;
    mob[i][4]=mob[i][2]*65536;
    mob[i][5]=mob[i][3]*65536;
    mob[i][14]=tp;
    mob[i][8]=mobhp[tp];

}


void LoadLevel(void)
{
    levelend=0;
    bullets0=0;
    bullets1=0;
    if (MusicPlaying!=9+level) PlayMusic(9+level);
    ClearMobs();
    FILE *fp;
    Uint32 ii,i;
    Uint8 c,mobi=1;
    levelloaded=level;
    sprintf(spath,"data/level%i.dat",level);
    fp=fopen(spath,"rb");
    ii=0;
    for (i=0; i<120000; i++)
    {
        c=fgetc(fp);
        levelcl[ii++]=c / 16;
        levelcl[ii++]=c % 16;
    }
    ii=0;
    for (i=0; i<120000; i++)
    {
        c=fgetc(fp);
        leveltg[ii++]=c / 16;
        leveltg[ii++]=c % 16;
    }
    ii=0;
    for (i=0; i<48000; i++)
    {
        c=fgetc(fp);
        levelbg0[ii++]=c / 16;
        levelbg0[ii++]=c % 16;
    }
    ii=0;
    for (i=0; i<12000; i++)
    {
        c=fgetc(fp);
        levelbg1[ii++]=c / 16;
        levelbg1[ii++]=c % 16;
    }

    fclose(fp);
    levelspecial=0;
    playerstate=0;
//reading info
    ii=0;
    camerax=0;
    cameratx=0;
    Uint8 itemi=0;
    cutscenes=0;
    cutscene=0;
    for (i=0; i<240000; i++)
    {
        c=leveltg[ii];
        switch (c)
        {
        case 0://player
            mob[0][0]=1;
            mob[0][2]=(ii % 2000);
            mob[0][3]=ii / 2000;
            mob[0][2]=mob[0][2]*2;
            OutFitMob(0,0);
            break;
        case 1://cutscenes
            cutscenex[cutscenes]=2*(ii % 2000);
            cutscenes++;
            break;
        case 2://item1
            item[itemi][1]=2*(ii % 2000);
            item[itemi][2]=ii / 2000;
            item[itemi][0]=1;
            itemi++;
            break;

        case 3://monster1
            mob[mobi][0]=1;
            mob[mobi][2]=(ii % 2000);
            mob[mobi][3]=ii / 2000;
            mob[mobi][2]=mob[mobi][2]*2;

            OutFitMob(mobi,4+level*2);

            mobi++;
            break;
        case 4://monster2
            mob[mobi][0]=1;
            mob[mobi][2]=(ii % 2000);
            mob[mobi][3]=ii / 2000;
            mob[mobi][2]=mob[mobi][2]*2;
            OutFitMob(mobi,5+level*2);

            mobi++;
            break;
        case 5://item2
            item[itemi][1]=2*(ii % 2000);
            item[itemi][2]=ii / 2000;
            item[itemi][0]=2;
            itemi++;
            break;

        }
        if (c<11) leveltg[ii]=0;
        ii+=2000;
        if (ii>=240000) {
            ii-=239999;
        };
    }
}
void RenderLevel(void)
{
    Uint32 x,y,i,ii,ii0,ii1;
    Uint8 c;
    i=0;
    camerax=camerax+(cameratx-camerax)/7;
    if (camerax<0) camerax=0;
    else if (camerax>3680)camerax=3680;
    Sint32 cx=camerax/2;


    ii=cx;
    ii0=cx*1000/2875;
    ii1=cx/46;

    for (y=0; y<120; y++)
    {

        for (x=0; x<160; x++)
        {
            if (leveltg[ii]>10)
            {
                scrbuf[i]=levelcl[ii];
                scrbuf[i+1]=levelcl[ii];
            }
            else
            {
                c=levelbg0[ii0+x];
                if (c!=10)
                {
                    scrbuf[i]=c;
                    scrbuf[i+1]=c;
                }
                else
                {
                    c=levelbg1[ii1+x];
                    scrbuf[i]=c;
                    scrbuf[i+1]=c;

                }

            }
            i+=2;
            ii++;
        }
        i+=320;
        ii+=1840;
        ii0+=800;
        ii1+=200;

    }
}

void RenderMobs(void)
{
    Uint8 i;
    Sint32 cx=camerax;
    for (i=0; i<64; i++)
        if (mob[i][0])
        {
            if (mob[i][2]-cx>-30)
                if (mob[i][2]-cx<350)
                {
                    if (mob[i][14] %2 ==1)
                        if (MusicPlaying!=7) PlayMusic(7);

                    if (mob[i][10])
                        DrawFlipSprite(64*3+mob[i][1],mob[i][2]-cx-16,mob[i][3]-16);
                    else
                        DrawSprite(64*3+mob[i][1],mob[i][2]-cx-16,mob[i][3]-16);
                }
        }

}
Uint8 blocke1[16]=
{
    0,0,0,0,
    0,0,0,0,
    0,0,0,0,
    1,1,0,1

};

void Destroy12(Uint32 i)
{
    levelcl[i]=0;
    leveltg[i]=0;
    if (leveltg[i-1]==12) Destroy12(i-1);
    if (leveltg[i+1]==12) Destroy12(i+1);
    if (leveltg[i-2000]==12) Destroy12(i-2000);
    if (leveltg[i+2000]==12) Destroy12(i+2000);


}
void RenderBullets(void)
{
    Uint8 i;
    for (i=0; i<32; i++)
        if (bullet[i][0]>0)
        {
            DrawSprite(16,bullet[i][2]-camerax-16,bullet[i][3]-8);
            bullet[i][0]++;
            if (bullet[i][1]) bullet[i][2]-=8;
            else bullet[i][2]+=8;

            if (bullet[i][0]>20) bullet[i][0]=0;
            else if (bullet[i][2]<2) bullet[i][0]=0;
            else if (bullet[i][2]>3998) bullet[i][0]=0;
            else if (bullet[i][3]<2) bullet[i][0]=0;
            else if (bullet[i][3]>118) bullet[i][0]=0;
            else
            {
                Uint32 ii=bullet[i][2]/2+bullet[i][3]*2000;
                if (leveltg[ii]==15)
                {   bullet[i][0]=0;
                    PlaySound(0,0);
                }
                else if (leveltg[ii]==12)
                {   Destroy12(ii);
                    bullet[i][0]=0;
                    PlaySound(7,0);
                }


                if (bullet[i][0])
                {
                    Uint8 k;
                    if (bullet[i][4]==0)
                    {
                        for (k=1; k<64; k++)
                            if (mob[k][0])
                                if (mob[k][8]>0)
                                    if (zabs(bullet[i][2]-mob[k][2])<20)
                                        if (zabs(bullet[i][3]-mob[k][3]+5)<10)
                                        {
                                            HurtMob(k);
                                            bullet[i][0]=0;
                                        }

                    }
                    else if (mob[0][0])
                        if (mob[0][8]>0)
                            if (zabs(bullet[i][2]-mob[0][2])<8)
                                if (zabs(bullet[i][3]-mob[0][3]+5)<8)
                                {
                                    HurtMob(0);
                                    bullet[i][0]=0;
                                }

                }
            }

        }
}

void RenderItems(void)
{
    Uint8 i;
    for (i=0; i<32; i++)
        if (item[i][0]>0)
        {
            DrawSprite(7+item[i][0],item[i][1]-camerax-16,item[i][2]-8-item[i][3]*3);

            if (item[i][3]==0)
                if (zabs(mob[0][2]-item[i][1])<16)
                    if (zabs(mob[0][3]-item[i][2])<14)
                    {
                        PlaySound(3,0);
                        item[i][3]=1;
                        mob[0][6]=0;
                        mob[0][7]=0;

                        if (item[i][0]==1) bullets0+=8;
                        else if (item[i][0]==2) bullets1+=15;

                    }
            if (item[i][3])
            {
                item[i][3]++;
                if (item[i][3]>10) item[i][0]=0;
            }

        }
}
void RenderGUI(void)
{
    Uint8 k;
    if (mob[0][8]>0)
        for (k=0; k<mob[0][8]; k++)
            DrawSprite(24,k*28,-2);
    if (bullets1)
    {
        for (k=0; k<bullets1; k++)
            DrawSprite(26,290-k*6,10);
    }
    if (bullets0)
    {
        for (k=0; k<bullets0; k++)
            if (k<20)
                DrawSprite(25,290-k*8,-2);
    }

}

void ProcGame(void)
{

    switch (levelspecial)
    {
    case 0://regular gameplay
        if (level!=levelloaded) LoadLevel();
        RenderLevel();
        ProcMobs();
        RenderItems();
        RenderBullets();
        RenderMobs();

        if (mob[0][8]>0) ProcPlayer();
        else if (mob[0][8]<-28) {
            levelloaded=128;
            NextGameState=5;
            EndGameState=1;
            levelend=0;
        }

        if (level<6) RenderGUI();

        if (levelend) {
            NextGameState=23;
            EndGameState=1;
            levelend=0;
        }

        if (mob[0][2]>3960)
            if (endlevel[level]==0)
                levelend=1;

        if (cutscenes)
            if (cutscene<cutscenes)
                if (mob[0][2]>cutscenex[cutscene])
                {
                    levelspecial=2;
                    oldmusic=MusicPlaying;
                    PlayMusic(5);
                    PlaySoundEx(6,0);
                    cutscenestate=0;
                    cutscenecount=0;
                }
        break;
    case 1://screen
        DrawScreen(screenid);
        screentime--;
        if (screentime==0) levelspecial=0;
        break;
    case 2://cutscene message
        PlayCutscene();
        break;
    }



}
