/* MoleInvasion - Copyright (C) - Guillaume Chambraud (linuxprocess@free.fr)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version. */

#include <unistd.h>
#if !defined(HAVE_GLES)
#include <GL/gl.h>
#else
#include <GLES/gl.h>
#endif
#ifndef WIN32
#include <dlfcn.h>
#endif
#include <SDL.h>
#include "video.h"

static int SMPEGlibinit=0; /* 0 : todo ; -1 : impossible ; 1 :done */

/* cf <smpeg/smpeg.h> */

void  *	(*ptr_SMPEG_new)	(char *, void * , int );
char  *	(*ptr_SMPEG_error)	(void * );
void	(*ptr_SMPEG_enableaudio)(void * , int );
void	(*ptr_SMPEG_enablevideo)(void * , int );
void	(*ptr_SMPEG_setvolume)	(void * , int );
void	(*ptr_SMPEG_setdisplay)	(void * , void * , void * , void *);
void	(*ptr_SMPEG_scaleXY)	(void * , int , int );
void	(*ptr_SMPEG_play)	(void * );
int	(*ptr_SMPEG_status)	(void * );
void	(*ptr_SMPEG_delete)	(void * );

void initSMPEGlib()
{	void * handle;
	
	SMPEGlibinit=-1;
	
#ifndef WIN32
	handle=dlopen("libsmpeg.so",RTLD_LAZY);
	if(!handle)
	{
               fprintf(stderr, "%s\n", dlerror());
               return;
	}
	ptr_SMPEG_new=dlsym(handle,"SMPEG_new");
	ptr_SMPEG_error=dlsym(handle,"SMPEG_error");
	ptr_SMPEG_enableaudio=dlsym(handle,"SMPEG_enableaudio");
	ptr_SMPEG_enablevideo=dlsym(handle,"SMPEG_enablevideo");
	ptr_SMPEG_setvolume=dlsym(handle,"SMPEG_setvolume");
	ptr_SMPEG_setdisplay=dlsym(handle,"SMPEG_setdisplay");
	ptr_SMPEG_scaleXY=dlsym(handle,"SMPEG_scaleXY");
	ptr_SMPEG_play=dlsym(handle,"SMPEG_play");
	ptr_SMPEG_status=dlsym(handle,"SMPEG_status");
	ptr_SMPEG_delete=dlsym(handle,"SMPEG_delete");

	if(ptr_SMPEG_new && ptr_SMPEG_error && ptr_SMPEG_enableaudio && ptr_SMPEG_enablevideo
	&& ptr_SMPEG_setvolume && ptr_SMPEG_setdisplay && ptr_SMPEG_scaleXY && ptr_SMPEG_play
	&& ptr_SMPEG_status && ptr_SMPEG_delete)
		SMPEGlibinit=1; /* OK */
	else
		fprintf(stderr, "%s\n", dlerror());
#endif
	return;
}

extern SDL_Surface * g_SDL_screen;

void updateSMPEG(SDL_Surface *screen, Sint32 x, Sint32 y, Uint32 w, Uint32 h)
{
    if ( screen->flags & SDL_DOUBLEBUF ) {
        SDL_Flip(screen);
    }
}

int playVideo(char * file, int use_audio)
{	void  *mpeg;
	int done,ret;

	if(!SMPEGlibinit)
		initSMPEGlib();
	if(SMPEGlibinit<0)
	{	fprintf(stderr, "No video : SMPEG lib not initialized :-(\n");
		return 1;
	}

	/* Create the MPEG stream */
	mpeg = (*ptr_SMPEG_new)(file, NULL, use_audio);
        if ( (*ptr_SMPEG_error)(mpeg) ) {
            fprintf(stderr, "%s: %s\n", file, (*ptr_SMPEG_error)(mpeg));
	    ret=1;
        }
	else
	{	(*ptr_SMPEG_enableaudio)(mpeg, use_audio);
	        (*ptr_SMPEG_enablevideo)(mpeg, 1/*use_video*/);
		if(use_audio)
		        (*ptr_SMPEG_setvolume)(mpeg, 100 /* max */);
		(*ptr_SMPEG_setdisplay)(mpeg, g_SDL_screen, NULL, updateSMPEG);
		(*ptr_SMPEG_scaleXY)(mpeg, g_SDL_screen->w, g_SDL_screen->h);

	        /* Play it, and wait for playback to complete */
	        (*ptr_SMPEG_play)(mpeg);
	        done = 0;
	        while ( !done && (*ptr_SMPEG_status)(mpeg) == 1/*SMPEG_PLAYING */)
		{	SDL_Event event;
			while ( SDL_PollEvent(&event) )
			{	switch (event.type)
				{case SDL_KEYDOWN:
	                	        if ( event.key.keysym.sym == SDLK_f )
						SDL_WM_ToggleFullScreen(g_SDL_screen);
					else
						done = 1;
                		        break;
				case SDL_JOYBUTTONDOWN:
					done = 1;
                		        break;
				case SDL_QUIT:
                        		done = 1;
	                	        break;
				}
			}
			SDL_Delay(200);
		}
		ret=0;
		(*ptr_SMPEG_delete)(mpeg);
	}
	return ret;
}
