/* MoleInvasion - Copyright (C) - Guillaume Chambraud (linuxprocess@free.fr)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version. */

#define MAIN_LEVEL
#include "level.h"
#include "font.h"
#include "events.h"
#include "worldmap.h"
#include "background.h"

/* booleans */
char g_display_background=2;
char g_display_foreground=1;
char g_display_map_only=0;
char g_display_map_on_it=0;
char g_display_map_behind_it=0;

/*****/

/* return non-nul if esc pressed */
int process_level_events( mySprite * player )
{	all_events_status events;

	events=events_get_all();

	player->goleft=events.left;
	player->goright=events.right;
	player->gojump=events.jump_kp;
	player->rebounce=events.jump;
	player->acceleration=events.accel;

	player->action=events.special_kp;

	if(events.F1_kp)
		g_display_background=g_display_background+1>2?0:g_display_background+1;
	if(events.F2_kp)
		g_display_foreground=!g_display_foreground;
	if(events.F3_kp)
	{	if(g_display_map_only)
		{	g_display_map_on_it=1;g_display_map_only=0;		}
		else if(g_display_map_on_it)
		{	g_display_map_behind_it=1;g_display_map_on_it=0;	}
		else if(g_display_map_behind_it)
		{	g_display_map_behind_it=0;	}
		else
			g_display_map_only=1;
	}

	if(events.quit)
		quit(0);
	if(events.esc)
		return 1;
	if(events.f_kp)
		SDL_WM_ToggleFullScreen(g_SDL_screen);
	if(events.p_kp)
	{	if(static_level_datas.pause)
			static_level_datas.pause=0;
		else
			static_level_datas.pause=1;
	}
	return 0;
}

/* retours: 0:en cours, 1:mort, 2:gagnant */
int manage_sprites(myList * level_walls,myList * level_motionless_sprites,myList * level_sprites, long decalX, long decalY)
{	unsigned int i,j;
	mySprite* current;

	/* gestion des lments graphiques */
	for(i=0;i<level_sprites->size;i++)
	{	current=(mySprite*)GetPosList(level_sprites,i);
		if(current->sprite_management_type == SPRITE_PLAYER)
		{	performPlayer(current,level_walls,level_motionless_sprites,level_sprites);
		}
		else if(current->sprite_management_type != SPRITE_TILE)
		{	/* on ne gere que les ennemis proches de l'cran */
			if( current->etat & ETAT_VISIBLE
			 && current->posX > -current->map->w-50 - decalX
			 && current->posX < SCREEN_WIDTH + 50 - decalX  )
				performOther(current,level_walls,level_motionless_sprites,level_sprites);
		}
	}
	
	/* contacts avec sprites immobiles (liste trie) */
	giveOrderedListPlage(&i,level_motionless_sprites, -decalX);
	for(j=i;j<level_motionless_sprites->size;j++)
	{	current=(mySprite*)GetPosList(level_motionless_sprites,j);
		/* fin de la partie trie intressante */
		if( !current || current->posX > g_SDL_screen->w - decalX )
			break;
		/* on ne gre que les sprites visibles  l'cran */
		if( current->etat & ETAT_VISIBLE )
			performOther(current,level_walls,level_motionless_sprites,level_sprites);
	}

	/* etat mort */
	if( ! (static_level_datas.global_player->etat & ETAT_VIVANT ))
		return 1;

	/* etat gagnant */
	if(static_level_datas.global_player->etat & ETAT_GAGNANT)
		return 2;

	/* jeu en cours */
	return 0;
}

int displaySpriteOrMap( mySprite sprite, SDL_Surface* screen, long decalX, long decalY)
{	if(g_display_map_only)
	{	return displaySpriteMap(sprite, screen, decalX, decalY);
	}
	else if(g_display_map_on_it)
	{	displaySprite(sprite, screen, decalX, decalY);
		return displaySpriteMap(sprite, screen, decalX, decalY);
	}
	else if(g_display_map_behind_it)
	{	displaySpriteMap(sprite, screen, decalX, decalY);
		return displaySprite(sprite, screen, decalX, decalY);
	}
	else
	{	return displaySprite(sprite, screen, decalX, decalY);
	}
}

void switchSprites(myList * level_motionless_sprites,myList * level_sprites)
{	unsigned int i;
	mySprite* current;
	
	/* on bascule toutes les gold_box(88) en coins(83) et rciproque */
	for(i=0;i<level_motionless_sprites->size;i++)
	{	current=(mySprite*)GetPosList(level_motionless_sprites,i);
		if(current -> id == 88)
			changeSpriteToId(current,83,NULL,NULL,NULL,0);
		else if(current -> id == 83)
			changeSpriteToId(current,88,NULL,NULL,NULL,0);
	}
	for(i=0;i<level_sprites->size;i++)
	{	current=(mySprite*)GetPosList(level_sprites,i);
		if(current -> id == 88)
			changeSpriteToId(current,83,NULL,NULL,NULL,0);
		else if(current -> id == 83)
			changeSpriteToId(current,88,NULL,NULL,NULL,0);
	}
}

void draw_list_to_screen(myList * listofsprites, long decalX, long decalY, char ordered_list)
{	unsigned int i,j;
	mySprite* current;
	int nb=0;

	/* positionnement des lments graphiques */
	if(ordered_list)
	{	giveOrderedListPlage(&i,listofsprites, -decalX);
		for(j=i;j<listofsprites->size;j++)
		{	current=(mySprite*)GetPosList(listofsprites,j);
			/* fin de la partie trie intressante */
			if( !current || current->posX > g_SDL_screen->w - decalX)
				break;
			displaySpriteOrMap(*current,g_SDL_screen,decalX,decalY);
			nb++;
		}
//		fprintf(stderr,"dessin de %d sprites tris\n",nb);
	}
	else
	{	for(i=0;i<listofsprites->size;i++)
			displaySpriteOrMap(*((mySprite*)GetPosList(listofsprites,i)),g_SDL_screen,decalX,decalY);
	}
}

void draw_foreground(char action, level_info infos, long decalX, long decalY)
{	
	static mySprite nuages[4];
	static mySprite rain,storm;static int storm_lenght;
	static mySprite night;
	int i;

	switch(infos.foreground)
	{case FRGRND_CLOUDS:
		if(action==DO_DRAW && g_display_foreground)
		{	for(i=0;i<4;i++)
			{	if(nuages[i].posX<static_level_datas.global_player->posX-g_SDL_screen->w)
				{	nuages[i].posX=rand()%g_SDL_screen->w+g_SDL_screen->w+static_level_datas.global_player->posX;
					nuages[i].posY=rand()%g_SDL_screen->h-nuages[i].imgH+50;
					nuages[i].horizontal_speed=rand()%5+1;
				}
				nuages[i].posX-=nuages[i].horizontal_speed;
				displaySprite(nuages[i],g_SDL_screen,decalX,decalY);
			}
		}
		else if(action==DO_INIT)
		{	LoadImgSprite(&nuages[0],"./gfx/nuage1.png");
			LoadImgSprite(&nuages[1],"./gfx/nuage1.png");
			LoadImgSprite(&nuages[2],"./gfx/nuage2.png");
			LoadImgSprite(&nuages[3],"./gfx/nuage2.png");
			for(i=0;i<4;i++)
				nuages[i].posX=nuages[i].posY=-g_SDL_screen->w;
		}
		else if(action==DO_FREE)
		{	for(i=0;i<4;i++)
				FreeImgSprite(nuages[i]);
		}
		break;
	case FRGRND_RAIN:
		if(action==DO_DRAW && g_display_foreground)
		{	displaySprite(rain,g_SDL_screen,-(rand()%20),-(rand()%40));
			if(rand()%200==0)
			{	storm_lenght=10;
				startTheSound("snd/storm.ogg");
			}
			if(storm_lenght)
			{	displaySprite(storm,g_SDL_screen,0,0);
				storm_lenght--;
			}
		}
		else if(action==DO_INIT)
		{	if(!g_opengl)
			{SDL_Surface * SDL_tile = SDL_CreateRGBSurface(g_SDL_screen->flags,
					g_SDL_screen->w, g_SDL_screen->h,
					g_SDL_screen->format->BitsPerPixel,
					g_SDL_screen->format->Rmask, g_SDL_screen->format->Gmask,
					g_SDL_screen->format->Bmask, g_SDL_screen->format->Amask);
			
			SDL_FillRect(SDL_tile, NULL, SDL_MapRGB(g_SDL_screen->format, 255, 255, 255));
			storm.image=SDL_DisplayFormat(SDL_tile);
			SDL_SetAlpha(storm.image, SDL_SRCALPHA   |SDL_RLEACCEL, 128);
			SDL_FreeSurface(SDL_tile);
			storm.etat=ETAT_VISIBLE;
			storm.posX=0;
			storm.posY=0;
			}
			else
				LoadImgSprite(&storm,"./gfx/storm.png");
			LoadImgSprite(&rain,"./gfx/rain.png");
			storm_lenght=0;
		}
		else if(action==DO_FREE)
		{	FreeImgSprite(rain);
			FreeImgSprite(storm);
		}
		break;
	case FRGRND_NIGHT:
		if(action==DO_DRAW && g_display_foreground)
		{	displaySprite(night,g_SDL_screen,0,0);
		}
		else if(action==DO_INIT)
		{	if(!g_opengl)
			{SDL_Surface * SDL_tile = SDL_CreateRGBSurface(g_SDL_screen->flags,
					g_SDL_screen->w, g_SDL_screen->h,
					g_SDL_screen->format->BitsPerPixel,
					g_SDL_screen->format->Rmask, g_SDL_screen->format->Gmask,
					g_SDL_screen->format->Bmask, g_SDL_screen->format->Amask);
			
			SDL_FillRect(SDL_tile, NULL, SDL_MapRGB(g_SDL_screen->format, 0, 0, 255));
			night.image=SDL_DisplayFormat(SDL_tile);
			SDL_SetAlpha(night.image, SDL_SRCALPHA   |SDL_RLEACCEL, 64);
			SDL_FreeSurface(SDL_tile);
			night.etat=ETAT_VISIBLE;
			night.posX=0;
			night.posY=0;
			}
			else
				LoadImgSprite(&night,"./gfx/night.png");
		}
		else if(action==DO_FREE)
		{	FreeImgSprite(night);
		}
		break;
	}
}

void draw_status(char action,int previous_state)
{
	static mySprite loser, winner, loser_txt, winner_txt;

	if(action==DO_DRAW)
	{	
		/* etat mort */
		if(previous_state==1)
		{	displaySprite(loser,g_SDL_screen,0,0);
			displaySprite(loser_txt,g_SDL_screen,0,0);
		}

		/* etat gagnant */
		if(previous_state==2)
		{	displaySprite(winner,g_SDL_screen,0,0);
			displaySprite(winner_txt,g_SDL_screen,0,0);
			font_render_integer(static_level_datas.elapsedTime,winner_txt.posX+200,
						winner_txt.posY+40);
			font_render_integer(static_level_datas.bestTime,winner_txt.posX+200,
						winner_txt.posY+5);
			font_render_integer(static_level_datas.getCoins,winner_txt.posX+350,
						winner_txt.posY+40);
			font_render_integer(static_level_datas.bestCoin,winner_txt.posX+350,
						winner_txt.posY+5);
		}
	}
	else if(action==DO_INIT)
	{	SDL_Color myText_bg={255,255,255};
		SDL_Color myText_fg={255,20,20};
		font_select(FONT_NAME,36,myText_fg,myText_bg,180);

		LoadImgSprite(&loser,"./gfx/ihm/loser.png");
		loser.posX=g_SDL_screen->w/2 - loser.imgW/2;
		loser.posY=g_SDL_screen->h/2 - loser.imgH/2;
		loser_txt = font_long_text("[LOSER]",0, 0);
		loser_txt.posX=g_SDL_screen->w/2 - loser_txt.imgW/2;
		loser_txt.posY=g_SDL_screen->h/2 - loser_txt.imgH/2;
		
		LoadImgSprite(&winner,"./gfx/ihm/winner.png");
		winner.posX=g_SDL_screen->w/2 - winner.imgW/2;
		winner.posY=g_SDL_screen->h/2 - winner.imgH/2;
		winner_txt = font_long_text("[WINNER]",0, 0);
		winner_txt.posX=g_SDL_screen->w/2 - winner_txt.imgW/2;
		winner_txt.posY=g_SDL_screen->h/2 - winner_txt.imgH/2;
	}
	else if(action==DO_FREE)
	{	FreeImgSprite(loser);
		FreeImgSprite(winner);
	}
}

void draw_bandeau(char action)
{	static mySprite bandeau,time;
	static SDL_Surface* accel;
	
	if(action==DO_DRAW)
	{	int y,x;
		SDL_Rect srcrect,dstrect;

		/* bandeau */
		x= 0;
		y= SCREEN_HEIGHT-60;
		displaySprite(bandeau,g_SDL_screen,x,y);
		
		/* time */
		x+= 20;
		y+= 15;
		displaySprite(time,g_SDL_screen,x,y);
		font_render_integer(static_level_datas.currentTime,x+time.imgW,y);
		
		/* switch */
		x+=297;
		y-= 5;
		font_render_integer(static_level_datas.switchTime,x,y);

		/* coins */
		x+=88;
		font_render_integer(static_world_datas.coins,x,y);
		
		/* acceleration */
		srcrect.x=0;
		srcrect.y=0;
		srcrect.h=(abs(static_level_datas.global_player->horizontal_speed)*36/*taille_max*/)/10/*vit max*/+2/*trait mini*/;
		srcrect.w=accel->w;
		dstrect.x=451;
		dstrect.y=53-srcrect.h;
		SDL_BlitSurface(accel,&srcrect,g_SDL_screen,&dstrect);
	}
	else if(action==DO_INIT)
	{	SDL_Color myText_bg={255,255,255};
		SDL_Color myText_fg={255,20,20};

		/* fonte */
		font_select(FONT_NAME,22,myText_fg,myText_bg,180);
		time = font_long_text("[TIME]",0, 0);

		/* bandeau */	
		LoadImgSprite(&bandeau,"gfx/ihm/bandeau.png");
		bandeau.posX=0;
		bandeau.posY=0;
		
		/* barre d'acclration */
		accel=SDL_CreateRGBSurface(g_SDL_screen->flags, 45, 40,
					g_SDL_screen->format->BitsPerPixel,
					g_SDL_screen->format->Rmask, g_SDL_screen->format->Gmask,
					g_SDL_screen->format->Bmask, g_SDL_screen->format->Amask);
		SDL_FillRect(accel, NULL, SDL_MapRGB(g_SDL_screen->format, 255, 0, 0));
		SDL_SetAlpha(accel, SDL_SRCALPHA|SDL_RLEACCEL,200);
	}
	else if(action==DO_FREE)
	{	FreeImgSprite(bandeau);
		FreeImgSprite(time);
		SDL_FreeSurface(accel);
	}
}

void performDecals(char action, level_info infos)
{	if(action==DO_INIT)
		static_level_datas.decalX=400-static_level_datas.global_player->posX;
	else if(action==DO_DRAW)
	{	if(infos.autoscroll)
			static_level_datas.decalX-=infos.autoscroll;
		else
			static_level_datas.decalX=400-static_level_datas.global_player->posX;
	}
	if(static_level_datas.decalX>0)
		static_level_datas.decalX=0;
}

void performDecalsToImprove(char action)
{	static int affect;

	if(action==DO_INIT)
		affect=0;
/*
	if(static_level_datas.global_player->horizontal_speed>0 && affect<100)
		affect+=4;
	else if(static_level_datas.global_player->horizontal_speed<0 && affect>-100)
		affect-=4;
	fprintf(stderr,"affect%d\n",affect);
*/
	static_level_datas.decalX=(SCREEN_WIDTH-400)-static_level_datas.global_player->posX-affect;
	if(static_level_datas.decalX>0)
		static_level_datas.decalX=0;
}
void performDecalsExpermiment(char action)
{	static long affect,pos,pX;
	static char sens;

	if(action==DO_INIT)
	{	sens=1;
		pX=static_level_datas.global_player->posX;
		affect=pX;
	}

	pos=static_level_datas.global_player->posX+static_level_datas.decalX-static_level_datas.global_player->horizontal_speed;
	fprintf(stderr,"pos=%ld decal=%ld\n",pos,static_level_datas.decalX);

	if(sens==1) /* vers la droite, donc a gauche de l'ecran */
	{	affect-=pX-static_level_datas.global_player->posX;
		pX=static_level_datas.global_player->posX;
		if(affect>160)
			sens=2;
	}
	else
	{	affect+=pX-static_level_datas.global_player->posX;
		pX=static_level_datas.global_player->posX;
		if(affect<-160)
			sens=1;
	}
	
/*
	if(static_level_datas.global_player->horizontal_speed>0 && affect<100)
		affect+=4;
	else if(static_level_datas.global_player->horizontal_speed<0 && affect>-100)
		affect-=4;
*/
	
	fprintf(stderr,"pX:%ld affect:%ld sens:%d\n",pX,affect,sens);

	static_level_datas.decalX=400-static_level_datas.global_player->posX-affect;
	if(static_level_datas.decalX>0)
		static_level_datas.decalX=0;
}
/* retourne 0 si le niveau est fni gagnant */
int main_level(char * level_file_name, int show_FPS, unsigned int bestTime, unsigned int bestCoin)
{
	/* niveau en cours */
	myList * level_walls=NULL;
	myList * level_motionless_sprites=NULL;
	myList * level_sprites=NULL;
	myList * level_foreground=NULL;
	level_info infos;
	int i,status;

	SDL_Color myText_bg={255,255,255};
	SDL_Color myText_fg={255,20,20};
	
	mySprite ft_name,ft_author,ft_wait;

				
	/* init the level infos */
	if(load_levelinfos(level_file_name,&infos))
	{	fprintf(stderr,"Error on load_levelinfos !\n");
		return 1;
	}

	/* pour la presentation */
	font_select(FONT_NAME,36,myText_fg,myText_bg,180);
	ft_name      = font_text(infos.level_name ,0, 400);
	ft_name.posX = g_SDL_screen->w/2 - ft_name.imgW/2;
	ft_author      = font_text(infos.author_name,0, 300);
	ft_author.posX = g_SDL_screen->w/2 - ft_author.imgW/2;
	ft_wait      = font_long_text("[WAIT]",0, 350);
	ft_wait.posX = g_SDL_screen->w/2 - ft_wait.imgW/2;

	/* init the music */
	startTheMusic(infos.music_file);
	
	/* init the graphics */
	draw_background(DO_INIT,  infos, 0, 0);
	draw_status(DO_INIT ,0);
	draw_bandeau(DO_INIT);

	/* dessin des dcors */
	draw_background(DO_DRAW, infos,0,0);
	displaySprite(ft_name, g_SDL_screen, 0, 0);
	displaySprite(ft_author, g_SDL_screen, 0, 0);
	displaySprite(ft_wait, g_SDL_screen, 0, 0);
	My_Flip();

	/* init the level gfx */
	if(init_all_images(infos.wall_gfx_dir,GAME_MODE))
	{	fprintf(stderr,"Error on init_all_images !\n");
		return 1;
	}

	while(1)
	{	Uint32 lastTime;
		char do_not_try_again;
		
		if(load_levelfile(level_file_name,&level_walls,&level_motionless_sprites,&level_sprites,&level_foreground))
		{	fprintf(stderr,"Error on load_levelfile !\n");
			status=1;
			break;
		}

		/* init the graphics */
		draw_foreground(DO_INIT ,  infos,0, 0);

		/* niveau de jeu en cours */
		memset(&static_level_datas,0,sizeof(static_level_datas));
		static_level_datas.currentTime=infos.time_limit;
		static_level_datas.bestTime=bestTime;
		static_level_datas.bestCoin=bestCoin;
		static_level_datas.decalY=0;

		/* player tjrs en dernire position de la liste */
		static_level_datas.global_player=GetPosList(level_sprites,level_sprites->size-1);
		if(!static_level_datas.global_player)
		{	printf("This file is not playable because no sprite player defined !!!\n");
			printf("Will certainly crash :-(\n");
		}
		
		/* rcupration de l'ventuelle dernire combinaison */
		if(static_world_datas.combi)
			changeSpriteToId(static_level_datas.global_player,static_world_datas.combi,level_walls,level_motionless_sprites,level_sprites,0);
		
		/* on pousse les sprites "coincs" */
		for(i=0;i<level_sprites->size;i++)
		{	mySprite* current=(mySprite*)GetPosList(level_sprites,i);
			if(current->sprite_management_type!=SPRITE_TILE)
				pousseSprite(current, level_walls,level_motionless_sprites,level_sprites);
		}
		
		/**************************/
		/* presentation du niveau */
		/**************************/
		performDecals(DO_INIT,infos);

		/* r-init des vnements */
		events_init();
		while(!any_event_found())
		{
			/* dessin des dcors */
			draw_background(DO_DRAW, infos,static_level_datas.decalX,static_level_datas.decalY);
			draw_foreground(DO_DRAW, infos,static_level_datas.decalX,static_level_datas.decalY);
			draw_bandeau(DO_DRAW);
			
			displaySprite(ft_name, g_SDL_screen, 0, 0);
			displaySprite(ft_author, g_SDL_screen, 0, 0);
			
			/* on bloque  30 FPS */
			coef_frame_rate(show_FPS);
			
			/* envoi au hard */
			My_Flip();
		}

		/*****************/
		/* jeu du niveau */
		/*****************/
		static_level_datas.pause=0;
		lastTime=SDL_GetTicks();
		status=0;
		while(!status)
		{
			if(!static_level_datas.pause)
			{	/* gestion des sprites */
				status=manage_sprites(level_walls,level_motionless_sprites,level_sprites,static_level_datas.decalX,static_level_datas.decalY);
			
				/* calcul des dcalages pour le scrolling */
				performDecals(DO_DRAW,infos);
			}
		
			/* dessin du niveau */
			draw_background(DO_DRAW, infos,static_level_datas.decalX,static_level_datas.decalY);
			draw_list_to_screen(level_walls,static_level_datas.decalX,static_level_datas.decalY,1);
			draw_list_to_screen(level_motionless_sprites,static_level_datas.decalX,static_level_datas.decalY,1);
			draw_list_to_screen(level_sprites,static_level_datas.decalX,static_level_datas.decalY,0);
			draw_list_to_screen(level_foreground,static_level_datas.decalX,static_level_datas.decalY,1);
			draw_foreground(DO_DRAW, infos,static_level_datas.decalX,static_level_datas.decalY);
			draw_bandeau(DO_DRAW);
			
			/* on bloque  30 FPS */
			coef_frame_rate(show_FPS);
			
			/* envoi au hard */
			My_Flip();
		
			/* gestion du switch */
			if(static_level_datas.switchTime == 10 && !static_level_datas.is_switched)
			{	switchSprites(level_motionless_sprites,level_sprites);
				static_level_datas.is_switched=1;
			}
			if(static_level_datas.switchTime == 0 && static_level_datas.is_switched)
			{	switchSprites(level_motionless_sprites,level_sprites);
				static_level_datas.is_switched=0;
			}

			/* gestion du temps */
			if(SDL_GetTicks()-lastTime>1000)
			{	if(!static_level_datas.pause)
				{	if(static_level_datas.currentTime>0)
						static_level_datas.currentTime--;
					if(static_level_datas.switchTime>0)
						static_level_datas.switchTime--;
				}
				lastTime+=1000;
				static_level_datas.elapsedTime++;
			}
			if(static_level_datas.currentTime<1)
				status=1;
				
			if(process_level_events(static_level_datas.global_player))
				status=1;
		}
		/*****************/
		/* niveau fini   */
		/*****************/
		if(status==1)
		{	/* perte de la combinaison */
			static_world_datas.combi=0;
			startTheSound("snd/end-lost.ogg");
		}
		else if(status==2)
		{	/* sauvegarde de la combinaison finale */
			static_world_datas.combi = static_level_datas.global_player->id;
			startTheSound("snd/end-win.ogg");
		}
		else
			fprintf(stderr,"level fini ??? : %d\n",status);

		/* r-init des vnements */
		events_init();
		static_level_datas.global_player->goright=static_level_datas.global_player->goleft=0;

		/* niveau en attente d'une touche <- ou -> */
		while(!static_level_datas.global_player->goright && !static_level_datas.global_player->goleft)
		{
			/* dessin du niveau */
			draw_background(DO_DRAW, infos,static_level_datas.decalX,static_level_datas.decalY);
			draw_list_to_screen(level_walls,static_level_datas.decalX,static_level_datas.decalY,1);
			draw_list_to_screen(level_motionless_sprites,static_level_datas.decalX,static_level_datas.decalY,1);
			draw_list_to_screen(level_sprites,static_level_datas.decalX,static_level_datas.decalY,0);
			draw_list_to_screen(level_foreground,static_level_datas.decalX,static_level_datas.decalY,1);
			draw_foreground(DO_DRAW, infos,static_level_datas.decalX,static_level_datas.decalY);
			draw_status(DO_DRAW, status);
			draw_bandeau(DO_DRAW);
			
			/* envoi au hard */
			My_Flip();
		
			/* on bloque  30 FPS */
			coef_frame_rate(show_FPS);

			if(process_level_events(static_level_datas.global_player) == 1)
				static_level_datas.global_player->goright=1;
		}
		do_not_try_again=static_level_datas.global_player->goright;

		/* liberation memoire */
		FreeList(level_walls);
		FreeList(level_motionless_sprites);
		FreeList(level_sprites);
		FreeList(level_foreground);
		draw_foreground(DO_FREE, infos, 0, 0);
		performDecals(DO_FREE,infos);

		/* succs ! */
		if(status==2)
		{	status=0;
			break;
		}
		
		/* sinon si on abandonne : retour  la map */
		if(do_not_try_again)
		{	status=1;
			break;
		}
		/* sinon chec, on reboucle sur le mme niveau */
	}
	
	/* free the graphics */
	draw_background(DO_FREE, infos, 0, 0);
	draw_status(DO_FREE ,0);
	draw_bandeau(DO_FREE);

	/* free the level */
	free_all_images();

	SDL_FreeSurface(ft_name.image);
	SDL_FreeSurface(ft_author.image);

	return status;
}
