/*
 This file is part of FleshChasmer.

    FleshChasmer is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FleshChasmer is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FleshChasmer.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "sectoreffect.h"
#include "sound.h"
#include "zmath.h"


#include "globalvar.h"
void SectorEffect(zzUint8 x,zzUint8 y,zzUint8 z)
{
    zzUint32 t=x+y*128+z*16384;
    zzUint8 effect=mapobj[t]-43;
    zzSint32 c;
    switch (effect)
    {
    case 0://Flesh wall wave effect
        c=(count*31+x*50+y*2+z*5)%4096;
        meshx[t]=x*65536+f_sin[c]/16;
        meshy[t]=y*65536+f_cos[c]/16;
        meshz[t]=z*65536+zabs(f_sin[(count*31+x*73+y*121+z*11)%2048]/16);
        break;
    }
}
