/*
 This file is part of FleshChasmer.

    FleshChasmer is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FleshChasmer is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FleshChasmer.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "controlpad.h"
#include "camera.h"
#include <stdlib.h>
#include "sound.h"
#include "editor.h"
#include "game.h"

static const zzSint8 dirpad[8][2]=
{{0,-1},{1,-1},{1,0},{1,1},{0,1},{-1,1},{-1,0},{-1,-1}};
void proccontrol(void)
{
    ControlPadUpdate();
}
void MiscProc(void)
{
    counttextureanimation=count/3%4;
    if (cscreenborder!=screenborder)
    {
        if (cscreenborder>screenborder) cscreenborder-=2;
        else cscreenborder+=2;

        screen_y0=cscreenborder;
        screen0_y0=screen_y0/2;
        screen_y1=239-cscreenborder;
        screen0_y1=screen_y1/2+1;
    }


}


void Gameprocess(void)
{
    MiscProc();
    proccontrol();
    ProcSound();
    if (EditorOn) ProcEditor();
    if (GameMode==GAME) gamestep();
    camproc();

}
