/*
 This file is part of FleshChasmer.

    FleshChasmer is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FleshChasmer is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FleshChasmer.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "fields.h"
#include "globalvar.h"
#include "zmath.h"

//spawn of field begin
zzUint8 field0_index,field0_type;
zzSint32 field0_x ,field0_y ,field0_z ;
zzSint32 field0_tx,field0_ty,field0_tz;
zzSint32 field0_ix,field0_iy,field0_iz;
zzSint32 field0_w,field0_iw;

//spawn of field end

void ProcFields(void)
{
    zzUint8 i;
    for (i=0; i<32; i++)
        if (field_ingame[i])
// else
        {
            field_x[i]+=field_ix[i];
            field_y[i]+=field_iy[i];
            field_z[i]+=field_iz[i];
            field_w[i]+=field_iw[i];

            field_index[i]++;

            field_count[i]++;
            if (field_count[i]==8) field_ingame[i]=0;
        }
}

void SpawnField(void)
{
    zzUint8 i=1;
    while ((i<32)&&(field_ingame[i]))
        i++;
    if (i==32) i=zzrandom(32);
    if (i==0) i=1;

    field_ingame[i]=1;

    field_x[i]=field0_x;
    field_y[i]=field0_y;
    field_z[i]=field0_z;

    field_ix[i]=field0_ix;
    field_iy[i]=field0_iy;
    field_iz[i]=field0_iz;

    field_w[i]=field0_w;
    field_iw[i]=field0_iw;
    field_index[i]=field0_index;
    field_count[i]=0;
}

void SpawnField0(zzSint32 x,zzSint32 y,zzSint32 z,zzUint8 t)
{
    zzUint8 i=1;
    while ((i<32)&(field_ingame[i]))
        i++;
    if (i==32) i=zzrandom(32);
    if (i==0) i=1;

    field_ingame[i]=1;

    field_x[i]=x;
    field_y[i]=y;
    field_z[i]=z;

    field_ix[i]=-500+zzrandom(1000);
    field_iy[i]=-500+zzrandom(1000);
    field_iz[i]=-500+zzrandom(1000);

    field_w[i]=20000;
    field_iw[i]=2000;

    zzSint32 tmp=t;
    tmp=tmp*8;
    tmp=248-tmp;
    field_index[i]=tmp;
    field_count[i]=0;
}

void SummonField(zzUint8 index,zzUint8 x,zzUint8 y,zzUint8 z)
{

}

void SummonFieldOn(zzUint8 index,zzUint8 target,zzUint8 owner)
{


}
