/*
 This file is part of FleshChasmer.

    FleshChasmer is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FleshChasmer is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FleshChasmer.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "camera.h"
#include "globalvar.h"
#include "zmath.h"

#define FPMUL(x,y)	((((x)>>6)*((y)>>6))>>4)
#define FPDIV(x,y)	((((x)<<6)/((y)>>6))>>4)

void camset(unsigned short int x,unsigned short int y,unsigned short int z)
{
    int i;
    zzSint32 t=x+y*128+z*16384;
    if (mapcam0[t])
    {
        if (mapcam0[t]<128)
        {
            for (i=0; i<6; i++)
                camera[i]=staticcam[mapcam0[t]-1][i];
        }
        else
        {   //Saint Code Here
            zzSint32 ang0=256*(mapcam1[t]&0xf);
            zzSint32 ang1=-128+64*(mapcam1[t]>>4);
            // ang0=(count/10%16)*256;
            if (ang1<0) ang1=4096+ang1;//Begone the tables of love/ virtue of code hash you
            zzSint32 rang=100000+20000*(mapcam2[t]&0xf)-camerazoom*28000;
            zzSint32 rangx=FPMUL(f_cos[ang1],rang);

//   zzSint32 ti=FPMUL(rang,f_sin[ang0]);

            camera[0]=meshx[t]+32666+FPMUL(rangx,f_cos[ang0]);
            camera[1]=meshz[t]+32666+FPMUL(rang,f_sin[ang1]);
            camera[2]=meshy[t]+32666+FPMUL(rangx,f_sin[ang0]);

            camera[3]=4096-ang1-200+25*(mapcam2[t]>>4);;

            camera[4]=3072-ang0-256+32*(mapcam3[t]&0xf);
            camera[5]=-512+64*(mapcam3[t]>>4);
        }
    }
}

void camproc(void)
{
    zzUint8 i;
    zzSint32 de;

    if (agressive_cam)
    {
        for (i=0; i<3; i++)
            rcamera[i]=rcamera[i]+(camera[i]-rcamera[i])/4;

        for (i=3; i<6; i++)
        {
            de=(camera[i]-rcamera[i]);
            if (de>2048) de=-4096+de;
            else if (de<-2048) de=4096+de;
            rcamera[i]+=de/4;
        }


    }
    else
    {
        for (i=0; i<3; i++)
            rcamera[i]=rcamera[i]+(camera[i]-rcamera[i])/8;

        for (i=3; i<6; i++)
        {
            de=(camera[i]-rcamera[i]);
            if (de>2048) de=-4096+de;
            else if (de<-2048) de=4096+de;
            rcamera[i]+=de/8;
        }
    }

    for (i=3; i<6; i++)
    {
        while (rcamera[i]<0) {
            rcamera[i]=4096+rcamera[i];
        }
        while (rcamera[i]>=4096) {
            rcamera[i]=rcamera[i]-4096;
        }
    }
    for (i=3; i<6; i++)
    {
        if (camera[i]<0) camera[i]=4096+camera[i];
        camera[i]=camera[i]%4096;
    }


}

void camsync(void)
{
    zzUint8 i;
    for (i=0; i<6; i++)
        rcamera[i]=camera[i];
}




int b_onmap_f(zzSint16 x,zzSint16 y,zzSint16 z)
{
    int i=1;

    if (x<0) i=0;
    if (y<0) i=0;
    if (z<0) i=0;
    if (x>levelx) i=0;
    if (y>levely) i=0;
    if (z>levelz) i=0;

    return i;
}

void procplayercamera(void)
{
    if (CameraMode)
    {
        zzSint32 a=SuperAngle(-monster_angle[0]+1024);
        zzUint8 c_far=1+CameraMode*2;
        camera[0]=monster_x[0]-f_cos[monster_angle[0]]*c_far;
        camera[1]=monster_z[0]+c_far*65536;
        camera[2]=monster_y[0]-f_sin[monster_angle[0]]*c_far;
        camera[3]=4096-436;
        camera[4]=a;
        camera[5]=0;
        camsync();
    }
    else
    {
        zzUint8 cx,cy,cz;
        zzSint32 x,y,z;


        zzSint32 cm[4][6],tx,ty,tz,delta;


        x=monster_x[0];
        y=monster_y[0];
        z=monster_z[0];

        x+=FPMUL(monster_radius[0]*12/15,f_cos[monster_angle[0]]);
        y+=FPMUL(monster_radius[0]*12/15,f_sin[monster_angle[0]]);
        cx=x/65536;
        cy=y/65536;
        cz=z/65536;

        zzUint32 roomi=cx+cy*128+cz*16384;

        zzUint8 cam=mapcam0[roomi];

        if (lastcamdelay)
        {   lastcamdelay--;
            if (lastcamdelay==0)
            {
                camset(cx,cy,cz);
                camsync();
                lastcamera=cam;
            }
        }
        else
        {

            {
                if (cam!=lastcamera)
                {
                    cameradelay=1;
                    camset(cx,cy,cz);
                    camsync();
                    GloomHazeCount=4;
                }
                else if (cam>=128)
                {
                    camset(cx,cy,cz);
                    zzUint8 i;
                    for (i=0; i<6; i++) cm[0][i]=camera[i];

                    tx=x-cx*65536-32768;
                    ty=y-cy*65536-32768;
                    tz=z-cz*65536;

                    if (tx<0)
                    {
                        if (cx>0)
                            if (mapcam0[roomi-1]==cam)
                            {
                                camset(cx-1,cy,cz);
                                zzUint8 i;
                                for (i=0; i<6; i++) cm[1][i]=camera[i];
                                delta=-tx;
                                for (i=0; i<3; i++) camera[i]=cm[0][i]+FPMUL((cm[1][i]-cm[0][i]),delta);
                                for (i=3; i<6; i++) camera[i]=cm[0][i]+FPMUL(calcturn(cm[0][i],cm[1][i]),delta);

                            }
                    }
                    else
                    {
                        if (cx<levelx)
                            if (mapcam0[roomi+1]==cam)
                            {
                                camset(cx+1,cy,cz);
                                zzUint8 i;
                                for (i=0; i<6; i++) cm[1][i]=camera[i];
                                delta=tx;
                                for (i=0; i<3; i++) camera[i]=cm[0][i]+FPMUL((cm[1][i]-cm[0][i]),delta);
                                for (i=3; i<6; i++) camera[i]=cm[0][i]+FPMUL(calcturn(cm[0][i],cm[1][i]),delta);

                            }
                    }
                    for (i=0; i<6; i++) cm[2][i]=camera[i];


                    if (ty<0)
                    {
                        if (cy>0)
                            if (mapcam0[roomi-128]==cam)
                            {
                                camset(cx,cy-1,cz);
                                zzUint8 i;
                                for (i=0; i<6; i++) cm[3][i]=camera[i];
                                delta=-ty;
                                for (i=0; i<3; i++) camera[i]=cm[2][i]+FPMUL((cm[3][i]-cm[2][i]),delta);
                                for (i=3; i<6; i++) camera[i]=cm[2][i]+FPMUL(calcturn(cm[2][i],cm[3][i]),delta);

                            }
                    }
                    else
                    {
                        if (cy<levely)
                            if (mapcam0[roomi+128]==cam)
                            {
                                camset(cx,cy+1,cz);
                                zzUint8 i;
                                for (i=0; i<6; i++) cm[3][i]=camera[i];
                                delta=ty;
                                for (i=0; i<3; i++) camera[i]=cm[2][i]+FPMUL((cm[3][i]-cm[2][i]),delta);
                                for (i=3; i<6; i++) camera[i]=cm[2][i]+FPMUL(calcturn(cm[2][i],cm[3][i]),delta);
                            }
                    }
                }

            }

            if (lastcamera!=cam)
            {
                lastcamdelay=16;
                lastcamera=cam;

// camset(cx,cy,cz);
                camsync();
                GloomHazeCount=4;
//debugval1=cam;

            }

        }


        debugval0=lastcamdelay;
    }
}
void ResetCamera(void)
{
    lastcamdelay=0;
}
                        delta=ty;
                                for (i=0; i<3; i++) camera[i]=cm[2][i]+FPMUL((cm[3][i]-cm[2][i]),delta);
                                for (i=3; i<6; i++) camera[i]=cm[2][i]+FPMUL(calcturn(cm[2][i],cm[3][i]),delta);
                            }
                    }
                }

            }

            if (lastcamera!=cam)
            {
                lastcamdelay=16;
                lastcamera=cam;

// camset(cx,cy,cz);
                camsync();
                GloomHazeCount=4;
//debugval1=cam;

            }

        }


        debugval0=lastcamdelay;
    }
}
void ResetCamera(void)
{
    lastcamdel
