/*****************************************************************************
 *
 *  Copyright (C) 2003 Cdric Brgardis <cedric.bregardis@free.fr>
 *  Copyright (C) 2011 Darius Hardy <darius@sephs.no-ip.info>
 *
 *  This file is part of BRIQUOLO
 *
 *  BRIQUOLO is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  BRIQUOLO is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with BRIQUOLO; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *****************************************************************************/
#include "MOGL_Texture.h"
#include "MOGL_Temps.h"
#ifdef HAVE_GLES
#include "GLES/gl.h"
#define GL_CLAMP GL_CLAMP_TO_EDGE
#else
#include "GL/gl.h"
#endif
#include "GL/glu.h"
#include <iostream>


MOGL_Texture::MOGL_Texture(MOGL_Enum_TypeTexture p_TypeTexture, bool p_AutoriserTrou, bool p_MipMap):
  MOGL_Image(p_AutoriserTrou), _Nom(0), _RepeterTexture(true), _TypeTexture(p_TypeTexture),
  _Animer(false), _VitesseX(0), _VitesseY(0), _VitesseRotation(0), _TranslationX(0), _TranslationY(0), _Rotation(0),
  _Temps(0), _MipMap(p_MipMap)

{
}

MOGL_Texture::~MOGL_Texture()
{
  if (_Nom!=0)
  {
    glDeleteTextures(1,&_Nom);
  }
}

void MOGL_Texture::Selectionner()
{
  if (_Animer)
  {
    _AnimerTexture();
    glMatrixMode(GL_TEXTURE);
    glLoadIdentity();
    glTranslatef(_TranslationX, _TranslationY, 0);
    glTranslatef(0.5, 0.5, 0);
    glRotatef(_Rotation,0,0,1);
    glTranslatef(-0.5, -0.5, 0);
    glMatrixMode(GL_MODELVIEW); 
  }
  else
  {
    glMatrixMode(GL_TEXTURE);
    glLoadIdentity();
    glTranslatef(_VitesseX, _VitesseY, 0);
    glRotatef(_VitesseRotation,0,0,1);
    glMatrixMode(GL_MODELVIEW); 
  }

  glBindTexture(GL_TEXTURE_2D,_Nom);
}

void MOGL_Texture::RepeterTexture(bool p_Val)
{
  _RepeterTexture=p_Val;
}

bool MOGL_Texture::ChargerBMP(const char * p_NomFichier)
{
  MOGL_Image::ChargerBMP(p_NomFichier);
  _Init();
  delete [] _Image;
  _Image=NULL;

  return true;
}


bool MOGL_Texture::ChargerPNG(const char * p_NomFichier)
{
  MOGL_Image::ChargerPNG(p_NomFichier);

  _Init();
  delete [] _Image;
  _Image=NULL;

  return true;
}

static void _Puissance2(unsigned int p_Nombre, unsigned int & p_NombrePuissance)
{
  for(int i=0;; i++)
  {
    p_NombrePuissance=static_cast<unsigned int>(pow(static_cast<float>(2), i));
    if (p_NombrePuissance >= p_Nombre)
    {
      return;
    }
  }
}

void MOGL_Texture::_Init()
{
  int res = 0;
#if defined(HAVE_GLES)
  unsigned int nouveauTailleX, nouveauTailleY;

  _Puissance2(_TailleX, nouveauTailleX);
  _Puissance2(_TailleY, nouveauTailleY);
  GLuint *imageNouveau=new GLuint[nouveauTailleX*nouveauTailleY];
  for(unsigned int y=0; y<nouveauTailleY; y++)
  {
    for(unsigned int x=0; x<nouveauTailleX; x++)
    {
      if (x<_TailleX && y<_TailleY)
      {
         MOGL_Struct_Couleur im = _Image[y*_TailleX+x];
         GLuint pix = min(int(im.a * 255.0f), 255);
         pix = (pix << 8) + min(int(im.b * 255.0f), 0xff);
         pix = (pix << 8) + min(int(im.g * 255.0f), 0xff);
         pix = (pix << 8) + min(int(im.r * 255.0f), 0xff);
         imageNouveau[y*nouveauTailleX+x] = pix;
      }
      else
      {
        imageNouveau[y*nouveauTailleX+x] = 0xff000000;
      }
    }
   }
  _RecX=static_cast<float>(_TailleX)/nouveauTailleX;
  _RecY=static_cast<float>(_TailleY)/nouveauTailleY;
#endif

  if (_Nom==0)
  {
    glGenTextures(1,&_Nom);
  }

  cout << "MOGL_Texture::_Init : glBindTexture("<< _NomFichier<< ", " << _MipMap << ");" <<endl;
  glBindTexture(GL_TEXTURE_2D,_Nom);
  if (_MipMap)
  {
#if !defined(HAVE_GLES)
    gluBuild2DMipmaps(GL_TEXTURE_2D, 4, _TailleX, _TailleY, GL_RGBA, GL_FLOAT, _Image);
#else
    glTexParameteri(GL_TEXTURE_2D, GL_GENERATE_MIPMAP, GL_TRUE);
    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, nouveauTailleX, nouveauTailleY, 0,
                 GL_RGBA,GL_UNSIGNED_BYTE, imageNouveau);
#endif
    res = glGetError();
    if (res != 0)
      cerr<<"glTexImage2D(MIP) error: "<<res<<endl;
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_NEAREST);
  }
  else
  {
    //glTexImage2D(GL_TEXTURE_2D,0,4,_TailleX,_TailleY,0,GL_RGBA,GL_FLOAT,_Image);
#if !defined(HAVE_GLES)
    glTexImage2D(GL_TEXTURE_2D,0,GL_RGBA,_TailleX,_TailleY,0,GL_RGBA,GL_FLOAT,_Image);
#else
    glTexImage2D(GL_TEXTURE_2D,0,GL_RGBA,nouveauTailleX,nouveauTailleY,0,GL_RGBA,GL_UNSIGNED_BYTE, imageNouveau);
#endif
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
  }

  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

  if (_RepeterTexture)
  {
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
  }
  else
  {
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
  }

  res = glGetError();
  if (res != 0)
  {
    cerr<<"glTexImage2D error: "<<res<<endl;
  }
#if defined(HAVE_GLES)
  delete [] imageNouveau;
#endif
}

MOGL_Texture::MOGL_Enum_TypeTexture MOGL_Texture::GetTypeTexture() const
{
  return _TypeTexture;
}

void MOGL_Texture::SetAnimation(bool p_Animer)
{
  _Animer=p_Animer;
}

bool MOGL_Texture::GetAnimation() const
{
  return _Animer;
}
        
void MOGL_Texture::SetVitesseTranslation(float p_VitesseX, float p_VitesseY)
{
  _VitesseX=p_VitesseX;
  _VitesseY=p_VitesseY;
}

void MOGL_Texture::SetVitesseRotation(float p_VitesseRotation)
{
  //_VitesseRotation=p_VitesseRotation*M_PI/180.0;
  _VitesseRotation=p_VitesseRotation;
}

void MOGL_Texture::_AnimerTexture()
{
  if (_Temps!=MOGL_Temps::GetTemps())
  {
    _Temps=MOGL_Temps::GetTemps();
    _TranslationX+=_VitesseX*MOGL_Temps::GetVariationTemps();
    _TranslationY+=_VitesseY*MOGL_Temps::GetVariationTemps();
    _Rotation+=_VitesseRotation*MOGL_Temps::GetVariationTemps();
  }
}

